/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationprofilestatus.traits.SecurityContextBuilder;
import org.apache.camel.v1.integrationprofilestatus.traits.securitycontext.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configuration", "enabled", "runAsNonRoot", "runAsUser", "seccompProfileType"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class SecurityContext
implements Editable<SecurityContextBuilder>,
KubernetesResource {
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="runAsNonRoot")
    @JsonPropertyDescription(value="Security Context RunAsNonRoot configuration (default false).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean runAsNonRoot;
    @JsonProperty(value="runAsUser")
    @JsonPropertyDescription(value="Security Context RunAsUser configuration (default none): this value is automatically retrieved in Openshift clusters when not explicitly set.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long runAsUser;
    @JsonProperty(value="seccompProfileType")
    @JsonPropertyDescription(value="Security Context SeccompProfileType configuration (default RuntimeDefault).")
    @JsonSetter(nulls=Nulls.SKIP)
    private SeccompProfileType seccompProfileType;

    public SecurityContextBuilder edit() {
        return new SecurityContextBuilder(this);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public SeccompProfileType getSeccompProfileType() {
        return this.seccompProfileType;
    }

    public void setSeccompProfileType(SeccompProfileType seccompProfileType) {
        this.seccompProfileType = seccompProfileType;
    }

    public String toString() {
        return "SecurityContext(configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", runAsNonRoot=" + this.getRunAsNonRoot() + ", runAsUser=" + this.getRunAsUser() + ", seccompProfileType=" + this.getSeccompProfileType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityContext)) {
            return false;
        }
        SecurityContext other = (SecurityContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$runAsNonRoot = this.getRunAsNonRoot();
        Boolean other$runAsNonRoot = other.getRunAsNonRoot();
        if (this$runAsNonRoot == null ? other$runAsNonRoot != null : !((Object)this$runAsNonRoot).equals(other$runAsNonRoot)) {
            return false;
        }
        Long this$runAsUser = this.getRunAsUser();
        Long other$runAsUser = other.getRunAsUser();
        if (this$runAsUser == null ? other$runAsUser != null : !((Object)this$runAsUser).equals(other$runAsUser)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        SeccompProfileType this$seccompProfileType = this.getSeccompProfileType();
        SeccompProfileType other$seccompProfileType = other.getSeccompProfileType();
        return !(this$seccompProfileType == null ? other$seccompProfileType != null : !((Object)((Object)this$seccompProfileType)).equals((Object)other$seccompProfileType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $runAsNonRoot = this.getRunAsNonRoot();
        result = result * 59 + ($runAsNonRoot == null ? 43 : ((Object)$runAsNonRoot).hashCode());
        Long $runAsUser = this.getRunAsUser();
        result = result * 59 + ($runAsUser == null ? 43 : ((Object)$runAsUser).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        SeccompProfileType $seccompProfileType = this.getSeccompProfileType();
        result = result * 59 + ($seccompProfileType == null ? 43 : ((Object)((Object)$seccompProfileType)).hashCode());
        return result;
    }

    public static enum SeccompProfileType {
        UNCONFINED("Unconfined"),
        RUNTIMEDEFAULT("RuntimeDefault");

        String value;

        private SeccompProfileType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

