/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.securitycontext;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.securitycontext.WindowsOptionsBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"gmsaCredentialSpec", "gmsaCredentialSpecName", "hostProcess", "runAsUserName"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class WindowsOptions
implements Editable<WindowsOptionsBuilder>,
KubernetesResource {
    @JsonProperty(value="gmsaCredentialSpec")
    @JsonPropertyDescription(value="GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String gmsaCredentialSpec;
    @JsonProperty(value="gmsaCredentialSpecName")
    @JsonPropertyDescription(value="GMSACredentialSpecName is the name of the GMSA credential spec to use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String gmsaCredentialSpecName;
    @JsonProperty(value="hostProcess")
    @JsonPropertyDescription(value="HostProcess determines if a container should be run as a 'Host Process' container. All of a Pod's containers must have the same effective HostProcess value (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers). In addition, if HostProcess is true then HostNetwork must also be set to true.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean hostProcess;
    @JsonProperty(value="runAsUserName")
    @JsonPropertyDescription(value="The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runAsUserName;

    public WindowsOptionsBuilder edit() {
        return new WindowsOptionsBuilder(this);
    }

    public String getGmsaCredentialSpec() {
        return this.gmsaCredentialSpec;
    }

    public void setGmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
    }

    public String getGmsaCredentialSpecName() {
        return this.gmsaCredentialSpecName;
    }

    public void setGmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
    }

    public Boolean getHostProcess() {
        return this.hostProcess;
    }

    public void setHostProcess(Boolean hostProcess) {
        this.hostProcess = hostProcess;
    }

    public String getRunAsUserName() {
        return this.runAsUserName;
    }

    public void setRunAsUserName(String runAsUserName) {
        this.runAsUserName = runAsUserName;
    }

    public String toString() {
        return "WindowsOptions(gmsaCredentialSpec=" + this.getGmsaCredentialSpec() + ", gmsaCredentialSpecName=" + this.getGmsaCredentialSpecName() + ", hostProcess=" + this.getHostProcess() + ", runAsUserName=" + this.getRunAsUserName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowsOptions)) {
            return false;
        }
        WindowsOptions other = (WindowsOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hostProcess = this.getHostProcess();
        Boolean other$hostProcess = other.getHostProcess();
        if (this$hostProcess == null ? other$hostProcess != null : !((Object)this$hostProcess).equals(other$hostProcess)) {
            return false;
        }
        String this$gmsaCredentialSpec = this.getGmsaCredentialSpec();
        String other$gmsaCredentialSpec = other.getGmsaCredentialSpec();
        if (this$gmsaCredentialSpec == null ? other$gmsaCredentialSpec != null : !this$gmsaCredentialSpec.equals(other$gmsaCredentialSpec)) {
            return false;
        }
        String this$gmsaCredentialSpecName = this.getGmsaCredentialSpecName();
        String other$gmsaCredentialSpecName = other.getGmsaCredentialSpecName();
        if (this$gmsaCredentialSpecName == null ? other$gmsaCredentialSpecName != null : !this$gmsaCredentialSpecName.equals(other$gmsaCredentialSpecName)) {
            return false;
        }
        String this$runAsUserName = this.getRunAsUserName();
        String other$runAsUserName = other.getRunAsUserName();
        return !(this$runAsUserName == null ? other$runAsUserName != null : !this$runAsUserName.equals(other$runAsUserName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WindowsOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hostProcess = this.getHostProcess();
        result = result * 59 + ($hostProcess == null ? 43 : ((Object)$hostProcess).hashCode());
        String $gmsaCredentialSpec = this.getGmsaCredentialSpec();
        result = result * 59 + ($gmsaCredentialSpec == null ? 43 : $gmsaCredentialSpec.hashCode());
        String $gmsaCredentialSpecName = this.getGmsaCredentialSpecName();
        result = result * 59 + ($gmsaCredentialSpecName == null ? 43 : $gmsaCredentialSpecName.hashCode());
        String $runAsUserName = this.getRunAsUserName();
        result = result * 59 + ($runAsUserName == null ? 43 : $runAsUserName.hashCode());
        return result;
    }
}

