/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.UDFContext;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class UDFContextImpl
implements UDFContext {
    private final Map<String, TypeCodec<Object>> byName = new HashMap<String, TypeCodec<Object>>();
    private final TypeCodec<Object>[] argCodecs;
    private final TypeCodec<Object> returnCodec;
    private final String keyspace;
    private final Supplier<KeyspaceMetadata> metadata;

    UDFContextImpl(List<ColumnIdentifier> argNames, TypeCodec<Object>[] argCodecs, TypeCodec<Object> returnCodec, String keyspace) {
        for (int i = 0; i < argNames.size(); ++i) {
            this.byName.put(argNames.get(i).toString(), argCodecs[i]);
        }
        this.argCodecs = argCodecs;
        this.returnCodec = returnCodec;
        this.keyspace = keyspace;
        this.metadata = Suppliers.memoize(() -> Schema.instance.getKSMetaData(keyspace));
    }

    @Override
    public UDTValue newArgUDTValue(String argName) {
        return UDFContextImpl.newUDTValue(this.codecFor(argName));
    }

    @Override
    public UDTValue newArgUDTValue(int argNum) {
        return UDFContextImpl.newUDTValue(this.codecFor(argNum));
    }

    @Override
    public UDTValue newReturnUDTValue() {
        return UDFContextImpl.newUDTValue(this.returnCodec);
    }

    @Override
    public UDTValue newUDTValue(String udtName) {
        Optional<UserType> udtType = ((KeyspaceMetadata)this.metadata.get()).types.get(ByteBufferUtil.bytes(udtName));
        DataType dataType = UDHelper.driverType(udtType.orElseThrow(() -> new IllegalArgumentException("No UDT named " + udtName + " in keyspace " + this.keyspace)));
        return UDFContextImpl.newUDTValue(dataType);
    }

    @Override
    public TupleValue newArgTupleValue(String argName) {
        return UDFContextImpl.newTupleValue(this.codecFor(argName));
    }

    @Override
    public TupleValue newArgTupleValue(int argNum) {
        return UDFContextImpl.newTupleValue(this.codecFor(argNum));
    }

    @Override
    public TupleValue newReturnTupleValue() {
        return UDFContextImpl.newTupleValue(this.returnCodec);
    }

    @Override
    public TupleValue newTupleValue(String cqlDefinition) {
        AbstractType<?> abstractType = CQLTypeParser.parse(this.keyspace, cqlDefinition, ((KeyspaceMetadata)this.metadata.get()).types);
        DataType dataType = UDHelper.driverType(abstractType);
        return UDFContextImpl.newTupleValue(dataType);
    }

    private TypeCodec<Object> codecFor(int argNum) {
        if (argNum < 0 || argNum >= this.argCodecs.length) {
            throw new IllegalArgumentException("Function does not declare an argument with index " + argNum);
        }
        return this.argCodecs[argNum];
    }

    private TypeCodec<Object> codecFor(String argName) {
        TypeCodec<Object> codec = this.byName.get(argName);
        if (codec == null) {
            throw new IllegalArgumentException("Function does not declare an argument named '" + argName + '\'');
        }
        return codec;
    }

    private static UDTValue newUDTValue(TypeCodec<Object> codec) {
        DataType dataType = codec.getCqlType();
        return UDFContextImpl.newUDTValue(dataType);
    }

    private static UDTValue newUDTValue(DataType dataType) {
        if (!(dataType instanceof com.datastax.driver.core.UserType)) {
            throw new IllegalStateException("Function argument is not a UDT but a " + dataType.getName());
        }
        com.datastax.driver.core.UserType userType = (com.datastax.driver.core.UserType)dataType;
        return userType.newValue();
    }

    private static TupleValue newTupleValue(TypeCodec<Object> codec) {
        DataType dataType = codec.getCqlType();
        return UDFContextImpl.newTupleValue(dataType);
    }

    private static TupleValue newTupleValue(DataType dataType) {
        if (!(dataType instanceof TupleType)) {
            throw new IllegalStateException("Function argument is not a tuple type but a " + dataType.getName());
        }
        TupleType tupleType = (TupleType)dataType;
        return tupleType.newValue();
    }
}

