/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.datastax.driver.mapping;

import java.lang.reflect.Constructor;

/** Utility methods related to reflection. */
class ReflectionUtils {

  static <T> T newInstance(Class<T> clazz) {
    Constructor<T> publicConstructor;
    try {
      publicConstructor = clazz.getConstructor();
    } catch (NoSuchMethodException e) {
      try {
        // try private constructor
        Constructor<T> privateConstructor = clazz.getDeclaredConstructor();
        privateConstructor.setAccessible(true);
        return privateConstructor.newInstance();
      } catch (Exception e1) {
        throw new IllegalArgumentException("Can't create an instance of " + clazz, e);
      }
    }
    try {
      return publicConstructor.newInstance();
    } catch (Exception e) {
      throw new IllegalArgumentException("Can't create an instance of " + clazz, e);
    }
  }
}
