/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.date;

import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class SimpleDateCodec
extends TypeCodec.PrimitiveIntCodec {
    public static final SimpleDateCodec instance = new SimpleDateCodec();
    private static final String pattern = "yyyy-MM-dd";

    public SimpleDateCodec() {
        super(DataType.date());
    }

    public ByteBuffer serializeNoBoxing(int value, ProtocolVersion protocolVersion) {
        return SimpleDateCodec.cint().serializeNoBoxing(CodecUtils.fromSignedToUnsignedInt((int)value), protocolVersion);
    }

    public int deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return 0;
        }
        return CodecUtils.fromUnsignedToSignedInt((int)SimpleDateCodec.cint().deserializeNoBoxing(bytes, protocolVersion));
    }

    public Integer parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted((String)value)) {
            value = ParseUtils.unquote((String)value);
        }
        if (ParseUtils.isLongLiteral((String)value)) {
            long unsigned;
            try {
                unsigned = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), (Throwable)e);
            }
            try {
                return CodecUtils.fromCqlDateToDaysSinceEpoch((long)unsigned);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), (Throwable)e);
            }
        }
        try {
            Date date = ParseUtils.parseDate((String)value, (String)pattern);
            return (int)TimeUnit.MILLISECONDS.toDays(date.getTime());
        }
        catch (ParseException e) {
            throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), (Throwable)e);
        }
    }

    public String format(Integer value) {
        if (value == null) {
            return "NULL";
        }
        long raw = CodecUtils.fromDaysSinceEpochToCqlDate((int)value);
        return ParseUtils.quote((String)Long.toString(raw));
    }
}

