/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.mapping.AccessorInvocationHandler;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.MethodMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

class AccessorMapper<T> {
    final Class<T> daoClass;
    final List<MethodMapper> methods;
    private final Class<T>[] proxyClasses;
    private final AccessorInvocationHandler<T> handler;

    AccessorMapper(Class<T> daoClass, List<MethodMapper> methods) {
        this.daoClass = daoClass;
        this.methods = methods;
        this.proxyClasses = new Class[]{daoClass};
        this.handler = new AccessorInvocationHandler(this);
    }

    T createProxy() {
        try {
            return (T)Proxy.newProxyInstance(this.daoClass.getClassLoader(), this.proxyClasses, this.handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create instance for Accessor interface " + this.daoClass.getName());
        }
    }

    void prepare(MappingManager manager) {
        ArrayList<ListenableFuture> statements = new ArrayList<ListenableFuture>(this.methods.size());
        for (MethodMapper method : this.methods) {
            statements.add(manager.getSession().prepareAsync(method.queryString));
        }
        try {
            List preparedStatements = (List)Futures.allAsList(statements).get();
            for (int i = 0; i < this.methods.size(); ++i) {
                this.methods.get(i).prepare(manager, (PreparedStatement)preparedStatements.get(i));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error preparing queries for accessor " + this.daoClass.getSimpleName(), e);
        }
    }
}

