/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.cluster.locator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioner;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Token;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRangeReplicas
implements Comparable<TokenRangeReplicas> {
    private final Token start;
    private final Token end;
    private final Partitioner partitioner;
    private final Set<String> replicaSet;
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenRangeReplicas.class);

    private TokenRangeReplicas(Token start, Token end, Partitioner partitioner, Set<String> replicaSet) {
        this.start = start;
        this.end = end;
        this.partitioner = partitioner;
        this.replicaSet = replicaSet;
    }

    public static List<TokenRangeReplicas> generateTokenRangeReplicas(Token start, Token end, Partitioner partitioner, Set<String> replicaSet) {
        if (start.compareTo(end) >= 0) {
            return TokenRangeReplicas.unwrapRange(start, end, partitioner, replicaSet);
        }
        LOGGER.debug("Generating replica-map for range: {} - {} : Replicaset: {}", new Object[]{start, end, replicaSet});
        return Collections.singletonList(new TokenRangeReplicas(start, end, partitioner, replicaSet));
    }

    public Token start() {
        return this.start;
    }

    public Token end() {
        return this.end;
    }

    public Set<String> replicaSet() {
        return this.replicaSet;
    }

    @Override
    public int compareTo(@NotNull TokenRangeReplicas other) {
        this.validateRangesForComparison(other);
        int compareStart = this.start.compareTo(other.start);
        return compareStart != 0 ? compareStart : this.end.compareTo(other.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenRangeReplicas that = (TokenRangeReplicas)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && this.partitioner == that.partitioner && this.replicaSet.equals(that.replicaSet);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.partitioner);
    }

    private void validateRangesForComparison(@NotNull TokenRangeReplicas other) {
        if (this.partitioner != other.partitioner) {
            throw new IllegalStateException("Token ranges being compared do not have the same partitioner");
        }
    }

    boolean contains(TokenRangeReplicas other) {
        this.validateRangesForComparison(other);
        return other.start.compareTo(this.start) >= 0 && other.end.compareTo(this.end) <= 0;
    }

    boolean intersects(TokenRangeReplicas other) {
        boolean inOrder = this.compareTo(other) <= 0;
        TokenRangeReplicas first = inOrder ? this : other;
        TokenRangeReplicas last = inOrder ? other : this;
        return first.end.compareTo(last.start) > 0 && first.start.compareTo(last.end) < 0;
    }

    private static List<TokenRangeReplicas> unwrapRange(Token start, Token end, Partitioner partitioner, Set<String> replicaSet) {
        if (end.compareTo(partitioner.minimumToken()) == 0) {
            return Collections.singletonList(new TokenRangeReplicas(start, partitioner.maximumToken(), partitioner, replicaSet));
        }
        if (start.compareTo(partitioner.maximumToken()) == 0) {
            return Collections.singletonList(new TokenRangeReplicas(partitioner.minimumToken(), end, partitioner, replicaSet));
        }
        ArrayList<TokenRangeReplicas> unwrapped = new ArrayList<TokenRangeReplicas>(2);
        unwrapped.add(new TokenRangeReplicas(start, partitioner.maximumToken(), partitioner, replicaSet));
        unwrapped.add(new TokenRangeReplicas(partitioner.minimumToken(), end, partitioner, replicaSet));
        return unwrapped;
    }

    public static List<TokenRangeReplicas> normalize(List<TokenRangeReplicas> ranges) {
        if (ranges.stream().noneMatch(r -> r.partitioner.minimumToken().compareTo(r.start()) == 0)) {
            LOGGER.warn("{} based minToken does not exist in the token ranges", (Object)ranges.stream().findFirst().map(r -> r.partitioner.name()).orElse("Unknown partitioner"));
        }
        return TokenRangeReplicas.deoverlap(ranges);
    }

    private static List<TokenRangeReplicas> deoverlap(List<TokenRangeReplicas> allRanges) {
        if (allRanges.isEmpty()) {
            return allRanges;
        }
        LOGGER.debug("Token ranges to be normalized: {}", allRanges);
        List<TokenRangeReplicas> ranges = TokenRangeReplicas.mergeIdenticalRanges(allRanges);
        ArrayList<TokenRangeReplicas> output = new ArrayList<TokenRangeReplicas>();
        Iterator<TokenRangeReplicas> iter = ranges.iterator();
        TokenRangeReplicas current = iter.next();
        while (iter.hasNext()) {
            TokenRangeReplicas next = iter.next();
            if (!current.intersects(next)) {
                output.add(current);
                current = next;
                continue;
            }
            current = TokenRangeReplicas.processIntersectingRanges(output, iter, current, next);
        }
        if (current != null) {
            output.add(current);
        }
        return output;
    }

    private static List<TokenRangeReplicas> mergeIdenticalRanges(List<TokenRangeReplicas> ranges) {
        HashMap<TokenRangeReplicas, Set<String>> rangeMapping = new HashMap<TokenRangeReplicas, Set<String>>();
        for (TokenRangeReplicas r : ranges) {
            if (!rangeMapping.containsKey(r)) {
                rangeMapping.put(r, r.replicaSet);
                continue;
            }
            ((Set)rangeMapping.get(r)).addAll(r.replicaSet);
        }
        ArrayList<TokenRangeReplicas> merged = new ArrayList<TokenRangeReplicas>();
        for (Map.Entry entry : rangeMapping.entrySet()) {
            TokenRangeReplicas r = (TokenRangeReplicas)entry.getKey();
            if (!r.replicaSet().equals(entry.getValue())) {
                r.replicaSet().addAll((Collection)entry.getValue());
            }
            merged.add(r);
        }
        Collections.sort(merged);
        return merged;
    }

    static TokenRangeReplicas processIntersectingRanges(List<TokenRangeReplicas> output, Iterator<TokenRangeReplicas> iter, TokenRangeReplicas current, TokenRangeReplicas next) {
        PriorityQueue<TokenRangeReplicas> rangeHeap = new PriorityQueue<TokenRangeReplicas>((n1, n2) -> !n1.end.equals(n2.end()) ? n1.end().compareTo(n2.end()) : n1.compareTo((TokenRangeReplicas)n2));
        ArrayList intersectingRanges = new ArrayList();
        next = TokenRangeReplicas.extractIntersectingRanges(intersectingRanges::add, iter, current, next);
        rangeHeap.add((TokenRangeReplicas)intersectingRanges.get(0));
        intersectingRanges.stream().skip(1L).forEach(r -> {
            if (!rangeHeap.isEmpty()) {
                Token newStart;
                TokenRangeReplicas range = (TokenRangeReplicas)rangeHeap.peek();
                Token token = newStart = output.isEmpty() ? range.start() : ((TokenRangeReplicas)output.get(output.size() - 1)).end();
                if (r.start().compareTo(((TokenRangeReplicas)rangeHeap.peek()).end()) == 0) {
                    output.add(new TokenRangeReplicas(newStart, r.start(), range.partitioner, TokenRangeReplicas.getBatchReplicas(rangeHeap)));
                    rangeHeap.poll();
                } else if (r.start().compareTo(((TokenRangeReplicas)rangeHeap.peek()).end()) > 0) {
                    output.add(new TokenRangeReplicas(newStart, range.end(), range.partitioner, TokenRangeReplicas.getBatchReplicas(rangeHeap)));
                    rangeHeap.poll();
                } else if (newStart.compareTo(r.start()) != 0) {
                    output.add(new TokenRangeReplicas(newStart, r.start(), range.partitioner, TokenRangeReplicas.getBatchReplicas(rangeHeap)));
                }
                rangeHeap.add((TokenRangeReplicas)r);
            }
        });
        while (!rangeHeap.isEmpty()) {
            Token newStart;
            LOGGER.debug("Non-empty heap while resolving intersecting ranges:" + rangeHeap.size());
            TokenRangeReplicas nextVal = (TokenRangeReplicas)rangeHeap.peek();
            Token token = newStart = output.isEmpty() ? nextVal.start() : output.get(output.size() - 1).end();
            if (newStart.compareTo(nextVal.end()) != 0) {
                output.add(new TokenRangeReplicas(newStart, nextVal.end(), nextVal.partitioner, TokenRangeReplicas.getBatchReplicas(rangeHeap)));
            }
            rangeHeap.poll();
        }
        return next;
    }

    private static TokenRangeReplicas extractIntersectingRanges(Consumer<TokenRangeReplicas> rangeConsumer, Iterator<TokenRangeReplicas> iter, TokenRangeReplicas current, TokenRangeReplicas next) {
        rangeConsumer.accept(current);
        rangeConsumer.accept(next);
        current = current.contains(next) ? current : next;
        next = null;
        while (iter.hasNext() && current.intersects(next = iter.next())) {
            rangeConsumer.accept(next);
            current = current.contains(next) ? current : next;
            next = null;
        }
        return next;
    }

    private static Set<String> getBatchReplicas(PriorityQueue<TokenRangeReplicas> rangeHeap) {
        return rangeHeap.stream().map(TokenRangeReplicas::replicaSet).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<String> mergeReplicas(TokenRangeReplicas current, TokenRangeReplicas next) {
        HashSet<String> merged = new HashSet<String>(current.replicaSet);
        merged.addAll(next.replicaSet);
        return merged;
    }

    public String toString() {
        return String.format("Range(%s, %s]: %s:%s", this.start.toString(), this.end.toString(), this.replicaSet, this.partitioner);
    }
}

