/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import io.vertx.ext.auth.authentication.CertificateCredentials;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.mtls.impl.SpiffeIdentityExtractor;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.sidecar.acl.AdminIdentityResolver;
import org.apache.cassandra.sidecar.acl.IdentityToRoleCache;

public class CassandraIdentityExtractor
extends SpiffeIdentityExtractor {
    private final IdentityToRoleCache identityToRoleCache;
    private final AdminIdentityResolver adminIdentityResolver;

    public CassandraIdentityExtractor(AdminIdentityResolver adminIdentityResolver, IdentityToRoleCache identityToRoleCache) {
        this.identityToRoleCache = identityToRoleCache;
        this.adminIdentityResolver = adminIdentityResolver;
    }

    public List<String> validIdentities(CertificateCredentials certificateCredentials) throws CredentialValidationException {
        List identities = super.validIdentities(certificateCredentials);
        ArrayList<String> allowedIdentities = new ArrayList<String>();
        for (String identity : identities) {
            if (!this.adminIdentityResolver.isAdmin(identity) && !this.identityToRoleCache.containsKey(identity)) continue;
            allowedIdentities.add(identity);
        }
        if (allowedIdentities.isEmpty()) {
            throw new CredentialValidationException("Could not extract valid identities from certificate");
        }
        return allowedIdentities;
    }
}

