/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cluster;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.exceptions.NoSuchCassandraInstanceException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancesMetadataImpl
implements InstancesMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstancesMetadataImpl.class);
    private static final long ONE_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private final AtomicLong lastUpdateTimestamp;
    private final DnsResolver dnsResolver;
    private final List<InstanceMetadata> instanceMetadataList;
    private final Map<Integer, InstanceMetadata> idToInstanceMetadata;
    private final Map<String, InstanceMetadata> hostNameToInstanceMetadata;
    private volatile Map<String, InstanceMetadata> ipToInstanceMetadata;

    public InstancesMetadataImpl(InstanceMetadata instanceMetadata, DnsResolver dnsResolver) {
        this(Collections.singletonList(instanceMetadata), dnsResolver);
    }

    public InstancesMetadataImpl(List<InstanceMetadata> instanceMetadataList, DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
        this.instanceMetadataList = instanceMetadataList;
        this.idToInstanceMetadata = new HashMap<Integer, InstanceMetadata>(instanceMetadataList.size());
        this.ipToInstanceMetadata = new HashMap<String, InstanceMetadata>(instanceMetadataList.size());
        this.hostNameToInstanceMetadata = new HashMap<String, InstanceMetadata>(instanceMetadataList.size());
        for (InstanceMetadata instanceMetadata : instanceMetadataList) {
            this.idToInstanceMetadata.put(instanceMetadata.id(), instanceMetadata);
            if (instanceMetadata.ipAddress() != null) {
                this.ipToInstanceMetadata.put(instanceMetadata.ipAddress(), instanceMetadata);
            }
            this.hostNameToInstanceMetadata.put(instanceMetadata.host(), instanceMetadata);
        }
        this.lastUpdateTimestamp = new AtomicLong(0L);
    }

    @Override
    @NotNull
    public List<InstanceMetadata> instances() {
        return this.instanceMetadataList;
    }

    @Override
    public InstanceMetadata instanceFromId(int id) throws NoSuchCassandraInstanceException {
        InstanceMetadata instanceMetadata = this.idToInstanceMetadata.get(id);
        if (instanceMetadata == null) {
            throw new NoSuchCassandraInstanceException("Instance id '" + id + "' not found");
        }
        return instanceMetadata;
    }

    @Override
    public InstanceMetadata instanceFromHost(String hostOrIpAddress) throws NoSuchCassandraInstanceException {
        InstanceMetadata instanceMetadata = this.hostNameToInstanceMetadata.get(hostOrIpAddress);
        if (instanceMetadata != null) {
            return instanceMetadata;
        }
        instanceMetadata = this.ipToInstanceMetadata.get(hostOrIpAddress);
        if (instanceMetadata != null) {
            return instanceMetadata;
        }
        String ipAddress = hostOrIpAddress;
        try {
            ipAddress = this.dnsResolver.resolve(hostOrIpAddress);
        }
        catch (UnknownHostException e) {
            LOGGER.debug("Failed to resolve IP address for {}", (Object)hostOrIpAddress);
        }
        this.maybeUpdateIpToInstanceMetadata();
        instanceMetadata = this.ipToInstanceMetadata.get(ipAddress);
        if (instanceMetadata != null) {
            return instanceMetadata;
        }
        throw new NoSuchCassandraInstanceException("Instance with host address '" + hostOrIpAddress + "' not found");
    }

    private void maybeUpdateIpToInstanceMetadata() {
        long lastValue;
        long now = System.currentTimeMillis();
        if (now - (lastValue = this.lastUpdateTimestamp.get()) <= ONE_SECOND || !this.lastUpdateTimestamp.compareAndSet(lastValue, now)) {
            return;
        }
        HashMap<String, InstanceMetadata> updated = new HashMap<String, InstanceMetadata>(this.instanceMetadataList.size());
        for (InstanceMetadata instanceMetadata : this.instanceMetadataList) {
            String ipAddress = instanceMetadata.ipAddress();
            try {
                ipAddress = instanceMetadata.refreshIpAddress();
            }
            catch (UnknownHostException uhe) {
                LOGGER.warn("Failed to resolve IP address from host. Going to use the existing IP address. host={}", (Object)instanceMetadata.host(), (Object)uhe);
            }
            if (ipAddress == null) continue;
            updated.put(ipAddress, instanceMetadata);
        }
        this.ipToInstanceMetadata = updated;
    }
}

