/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.KeyStoreConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreConfigurationImpl
implements KeyStoreConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreConfigurationImpl.class);
    @JsonProperty(value="path")
    protected final String path;
    @JsonProperty(value="password")
    protected final String password;
    @JsonProperty(value="type")
    protected final String type;
    protected SecondBoundConfiguration checkInterval;

    public KeyStoreConfigurationImpl() {
        this(null, null, "JKS", SecondBoundConfiguration.ZERO);
    }

    public KeyStoreConfigurationImpl(String path, String password) {
        this(path, password, "JKS", SecondBoundConfiguration.ZERO);
    }

    public KeyStoreConfigurationImpl(String path, String password, String type) {
        this(path, password, type, SecondBoundConfiguration.ZERO);
    }

    public KeyStoreConfigurationImpl(String path, String password, String type, SecondBoundConfiguration checkInterval) {
        this.path = path;
        this.password = password;
        this.type = type;
        this.checkInterval = checkInterval;
    }

    @Override
    @JsonProperty(value="path")
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty(value="password")
    public String password() {
        return this.password;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="check_interval")
    public SecondBoundConfiguration checkInterval() {
        return this.checkInterval;
    }

    @JsonProperty(value="check_interval")
    public void setCheckInterval(SecondBoundConfiguration checkInterval) {
        this.checkInterval = checkInterval;
    }

    @JsonProperty(value="check_interval_sec")
    @Deprecated
    public void setCheckIntervalInSeconds(long checkIntervalInSeconds) {
        LOGGER.warn("'check_interval_sec' is deprecated, use 'check_interval' instead");
        this.setCheckInterval(new SecondBoundConfiguration(checkIntervalInSeconds, TimeUnit.SECONDS));
    }
}

