/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.TrafficShapingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficShapingConfigurationImpl
implements TrafficShapingConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrafficShapingConfigurationImpl.class);
    public static final long DEFAULT_INBOUND_GLOBAL_BANDWIDTH_LIMIT = 0L;
    public static final long DEFAULT_OUTBOUND_GLOBAL_BANDWIDTH_LIMIT = 0L;
    public static final long DEFAULT_PEAK_OUTBOUND_GLOBAL_BANDWIDTH_LIMIT = 0x19000000L;
    public static final MillisecondBoundConfiguration DEFAULT_MAX_DELAY_TIME = MillisecondBoundConfiguration.parse((String)"15s");
    public static final MillisecondBoundConfiguration DEFAULT_CHECK_INTERVAL = MillisecondBoundConfiguration.parse((String)"1s");
    public static final long DEFAULT_INBOUND_FILE_GLOBAL_BANDWIDTH_LIMIT = 0L;
    @JsonProperty(value="inbound_global_bandwidth_bps")
    protected final long inboundGlobalBandwidthBytesPerSecond;
    @JsonProperty(value="outbound_global_bandwidth_bps")
    protected final long outboundGlobalBandwidthBytesPerSecond;
    @JsonProperty(value="peak_outbound_global_bandwidth_bps")
    protected final long peakOutboundGlobalBandwidthBytesPerSecond;
    protected MillisecondBoundConfiguration maxDelayToWait;
    protected MillisecondBoundConfiguration checkIntervalForStats;
    @JsonProperty(value="inbound_global_file_bandwidth_bps")
    protected final long inboundGlobalFileBandwidthBytesPerSecond;

    public TrafficShapingConfigurationImpl() {
        this(0L, 0L, 0x19000000L, DEFAULT_MAX_DELAY_TIME, DEFAULT_CHECK_INTERVAL, 0L);
    }

    public TrafficShapingConfigurationImpl(long inboundGlobalBandwidthBytesPerSecond, long outboundGlobalBandwidthBytesPerSecond, long peakOutboundGlobalBandwidthBytesPerSecond, MillisecondBoundConfiguration maxDelayToWait, MillisecondBoundConfiguration checkIntervalForStats, long inboundGlobalFileBandwidthBytesPerSecond) {
        this.inboundGlobalBandwidthBytesPerSecond = inboundGlobalBandwidthBytesPerSecond;
        this.outboundGlobalBandwidthBytesPerSecond = outboundGlobalBandwidthBytesPerSecond;
        this.peakOutboundGlobalBandwidthBytesPerSecond = peakOutboundGlobalBandwidthBytesPerSecond;
        this.maxDelayToWait = maxDelayToWait;
        this.checkIntervalForStats = checkIntervalForStats;
        this.inboundGlobalFileBandwidthBytesPerSecond = inboundGlobalFileBandwidthBytesPerSecond;
    }

    @Override
    @JsonProperty(value="inbound_global_bandwidth_bps")
    public long inboundGlobalBandwidthBytesPerSecond() {
        return this.inboundGlobalBandwidthBytesPerSecond;
    }

    @Override
    @JsonProperty(value="outbound_global_bandwidth_bps")
    public long outboundGlobalBandwidthBytesPerSecond() {
        return this.outboundGlobalBandwidthBytesPerSecond;
    }

    @Override
    @JsonProperty(value="peak_outbound_global_bandwidth_bps")
    public long peakOutboundGlobalBandwidthBytesPerSecond() {
        return this.peakOutboundGlobalBandwidthBytesPerSecond;
    }

    @Override
    @JsonProperty(value="max_delay_to_wait")
    public MillisecondBoundConfiguration maxDelayToWait() {
        return this.maxDelayToWait;
    }

    @JsonProperty(value="max_delay_to_wait")
    public void setMaxDelayToWait(MillisecondBoundConfiguration maxDelayToWait) {
        this.maxDelayToWait = maxDelayToWait;
    }

    @JsonProperty(value="max_delay_to_wait_millis")
    @Deprecated
    public void setMaxDelayToWaitMillis(long maxDelayToWaitMillis) {
        LOGGER.warn("'max_delay_to_wait_millis' is deprecated, use 'max_delay_to_wait' instead");
        this.setMaxDelayToWait(new MillisecondBoundConfiguration(maxDelayToWaitMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="check_interval_for_stats")
    public MillisecondBoundConfiguration checkIntervalForStats() {
        return this.checkIntervalForStats;
    }

    @JsonProperty(value="check_interval_for_stats")
    public void setCheckIntervalForStats(MillisecondBoundConfiguration checkIntervalForStats) {
        this.checkIntervalForStats = checkIntervalForStats;
    }

    @JsonProperty(value="check_interval_for_stats_millis")
    @Deprecated
    public void setCheckIntervalForStatsMillis(long checkIntervalForStatsMillis) {
        LOGGER.warn("'check_interval_for_stats_millis' is deprecated, use 'check_interval_for_stats' instead");
        this.setCheckIntervalForStats(new MillisecondBoundConfiguration(checkIntervalForStatsMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="inbound_global_file_bandwidth_bps")
    public long inboundGlobalFileBandwidthBytesPerSecond() {
        return this.inboundGlobalFileBandwidthBytesPerSecond;
    }
}

