/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.cdc;

import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.sidecar.common.request.Service;
import org.apache.cassandra.sidecar.utils.HttpExceptions;

@Singleton
public class ServiceConfigValidator {
    public Service validateAndGet(String requestService) {
        try {
            return Service.withName((String)requestService);
        }
        catch (Exception e) {
            Set services = Stream.of(Service.values()).map(v -> v.serviceName).collect(Collectors.toSet());
            String supportedServices = String.join((CharSequence)", ", services);
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid service provided. Supported services: " + supportedServices);
        }
    }

    public void validateConfig(JsonObject payload) {
        try {
            payload.getJsonObject("config").getMap();
        }
        catch (ClassCastException ex) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid configuration provided");
        }
    }

    public void validatePayload(JsonObject payload) {
        if (!payload.containsKey("config")) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid request payload. config needs to be passed");
        }
    }
}

