/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.tasks;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.function.Function;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.SslConfiguration;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.apache.cassandra.sidecar.utils.EventBusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCheckPeriodicTask
implements PeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreCheckPeriodicTask.class);
    private final Vertx vertx;
    private final SslConfiguration sslConfiguration;
    private final Function<Long, Future<Boolean>> updateSSLOptionsFunction;
    private long lastModifiedTime = 0L;
    private final String taskName;

    protected KeyStoreCheckPeriodicTask(Vertx vertx, SslConfiguration sslConfiguration, Function<Long, Future<Boolean>> updateSSLOptionsFunction, String taskName) {
        this.vertx = vertx;
        this.sslConfiguration = sslConfiguration;
        this.updateSSLOptionsFunction = updateSSLOptionsFunction;
        this.taskName = taskName;
    }

    public static KeyStoreCheckPeriodicTask forServer(Vertx vertx, SidecarConfiguration configuration, Function<Long, Future<Boolean>> updateSSLOptionsFunction) {
        return new KeyStoreCheckPeriodicTask(vertx, configuration.sslConfiguration(), updateSSLOptionsFunction, "ServerKeyStoreCheckPeriodicTask");
    }

    public static KeyStoreCheckPeriodicTask forClient(Vertx vertx, SidecarConfiguration configuration, Function<Long, Future<Boolean>> updateSSLOptionsFunction) {
        return new KeyStoreCheckPeriodicTask(vertx, configuration.sidecarClientConfiguration().sslConfiguration(), updateSSLOptionsFunction, "ClientKeyStoreCheckPeriodicTask");
    }

    @Override
    public String name() {
        return this.taskName;
    }

    @Override
    public void deploy(Vertx vertx, PeriodicTaskExecutor executor) {
        if (this.sslConfiguration != null && this.sslConfiguration.enabled() && this.sslConfiguration.keystore() != null && this.sslConfiguration.keystore().isConfigured() && this.sslConfiguration.keystore().reloadStore()) {
            this.maybeRecordLastModifiedTime();
            EventBusUtils.onceLocalConsumer(vertx.eventBus(), SidecarServerEvents.ON_SERVER_START.address(), message -> executor.schedule(this));
        }
    }

    @Override
    public ScheduleDecision scheduleDecision() {
        return this.shouldSkip() ? ScheduleDecision.SKIP : ScheduleDecision.EXECUTE;
    }

    @Override
    public DurationSpec delay() {
        return this.sslConfiguration.keystore().checkInterval();
    }

    @Override
    public void execute(Promise<Void> promise) {
        LOGGER.info("Running periodic key store checker");
        String keyStorePath = this.sslConfiguration.keystore().path();
        this.vertx.fileSystem().props(keyStorePath).onSuccess(props -> {
            long previousLastModifiedTime = this.lastModifiedTime;
            if (props.lastModifiedTime() != previousLastModifiedTime) {
                LOGGER.info("Certificate file change detected for path={}, previousLastModifiedTime={}, lastModifiedTime={}", new Object[]{keyStorePath, previousLastModifiedTime, props.lastModifiedTime()});
                this.updateSSLOptionsFunction.apply(props.lastModifiedTime()).onSuccess(v -> {
                    this.lastModifiedTime = props.lastModifiedTime();
                    LOGGER.info("Completed reloading certificates from path={}", (Object)keyStorePath);
                    promise.complete();
                }).onFailure(cause -> {
                    LOGGER.error("Failed to reload certificate from path={}", (Object)keyStorePath, cause);
                    promise.fail(cause);
                });
            } else {
                promise.complete();
            }
        }).onFailure(error -> {
            LOGGER.warn("Unable to retrieve props for path={}", (Object)keyStorePath, error);
            promise.fail(error);
        });
    }

    protected void maybeRecordLastModifiedTime() {
        if (this.shouldSkip()) {
            return;
        }
        String keyStorePath = this.sslConfiguration.keystore().path();
        this.vertx.fileSystem().props(keyStorePath).onSuccess(props -> {
            this.lastModifiedTime = props.lastModifiedTime();
        }).onFailure(err -> {
            LOGGER.error("Unable to get lastModifiedTime for path={}", (Object)keyStorePath);
            this.lastModifiedTime = -1L;
        });
    }

    private boolean shouldSkip() {
        return !this.sslConfiguration.isKeystoreConfigured() || !this.sslConfiguration.keystore().reloadStore();
    }
}

