/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.retry;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.exception.RetriesExhaustedException;
import org.apache.cassandra.sidecar.client.retry.RetryAction;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.utils.TimeUtils;

public class OncePerInstanceRetryPolicy
extends RetryPolicy {
    private final Duration minimumDelay;
    private final Duration maximumDelay;

    public OncePerInstanceRetryPolicy() {
        this(Duration.ZERO, Duration.ZERO);
    }

    public OncePerInstanceRetryPolicy(Duration minimumDelay, Duration maximumDelay) {
        this.minimumDelay = minimumDelay;
        this.maximumDelay = maximumDelay;
    }

    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (response != null && response.statusCode() == HttpResponseStatus.OK.code()) {
            responseFuture.complete(response);
        } else if (canRetryOnADifferentHost) {
            retryAction.retry(attempts + 1, TimeUtils.randomDuration((Duration)this.minimumDelay, (Duration)this.maximumDelay).toMillis());
        } else {
            responseFuture.completeExceptionally(RetriesExhaustedException.of(attempts, request, response, throwable));
        }
    }
}

