/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.MergeDirection;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.validation.SimpleValidationFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToDbToken
implements MergerToken,
Comparable<MergerToken> {
    @Override
    public final MergeDirection getDirection() {
        return MergeDirection.TO_DB;
    }

    @Override
    public void execute(MergerContext mergerContext) {
        for (String sql : this.createSql(mergerContext.getAdapter())) {
            this.executeSql(mergerContext, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSql(MergerContext mergerContext, String sql) {
        Connection conn = null;
        Statement st = null;
        JdbcEventLogger logger = mergerContext.getDataNode().getJdbcEventLogger();
        try {
            logger.log(sql);
            conn = mergerContext.getDataNode().getDataSource().getConnection();
            st = conn.createStatement();
            st.execute(sql);
        }
        catch (SQLException e) {
            mergerContext.getValidationResult().addFailure(new SimpleValidationFailure(sql, e.getMessage()));
            logger.logQueryError(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public String toString() {
        StringBuilder ts = new StringBuilder();
        ts.append(this.getTokenName());
        ts.append(' ');
        ts.append(this.getTokenValue());
        ts.append(' ');
        ts.append((Object)this.getDirection());
        return ts.toString();
    }

    public abstract List<String> createSql(DbAdapter var1);

    static abstract class EntityAndColumn
    extends Entity {
        private DbAttribute column;

        public EntityAndColumn(DbEntity entity, DbAttribute column) {
            super(entity);
            this.column = column;
        }

        public DbAttribute getColumn() {
            return this.column;
        }

        public String getTokenValue() {
            return this.getEntity().getName() + "." + this.getColumn().getName();
        }
    }

    static abstract class Entity
    extends AbstractToDbToken {
        private DbEntity entity;

        public Entity(DbEntity entity) {
            this.entity = entity;
        }

        public DbEntity getEntity() {
            return this.entity;
        }

        public String getTokenValue() {
            return this.getEntity().getName();
        }

        protected QuotingStrategy getQuotingStrategy(DbAdapter adapter) {
            return adapter.getQuotingStrategy(this.getEntity().getDataMap().isQuotingSQLIdentifiers());
        }

        public int compareTo(MergerToken o) {
            return 0;
        }
    }
}

