/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.plaf.basic;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import javax.swing.plaf.UIResource;

public class BasicGraphTransferable
implements Transferable,
UIResource,
Serializable {
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
        int n2 = this.isHTMLSupported() ? htmlFlavors.length : 0;
        int n3 = this.isPlainSupported() ? plainFlavors.length : 0;
        int n4 = this.isPlainSupported() ? stringFlavors.length : 0;
        int n5 = n + n2 + n3 + n4;
        DataFlavor[] dataFlavorArray2 = new DataFlavor[n5];
        int n6 = 0;
        if (n > 0) {
            System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, n6, n);
            n6 += n;
        }
        if (n2 > 0) {
            System.arraycopy(htmlFlavors, 0, dataFlavorArray2, n6, n2);
            n6 += n2;
        }
        if (n3 > 0) {
            System.arraycopy(plainFlavors, 0, dataFlavorArray2, n6, n3);
            n6 += n3;
        }
        if (n4 > 0) {
            System.arraycopy(stringFlavors, 0, dataFlavorArray2, n6, n4);
            n6 += n4;
        }
        return dataFlavorArray2;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isRicherFlavor(dataFlavor)) {
            return this.getRicherData(dataFlavor);
        }
        if (this.isHTMLFlavor(dataFlavor)) {
            String string = this.getHTMLData();
            string = string == null ? "" : string;
            if ((class$java$lang$String == null ? (class$java$lang$String = BasicGraphTransferable.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if ((class$java$io$Reader == null ? (class$java$io$Reader = BasicGraphTransferable.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = BasicGraphTransferable.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(string);
            }
        } else if (this.isPlainFlavor(dataFlavor)) {
            String string = this.getPlainData();
            string = string == null ? "" : string;
            if ((class$java$lang$String == null ? (class$java$lang$String = BasicGraphTransferable.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if ((class$java$io$Reader == null ? (class$java$io$Reader = BasicGraphTransferable.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = BasicGraphTransferable.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(string);
            }
        } else if (this.isStringFlavor(dataFlavor)) {
            String string = this.getPlainData();
            string = string == null ? "" : string;
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected boolean isRicherFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor[] getRicherFlavors() {
        return null;
    }

    protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        return null;
    }

    protected boolean isHTMLFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = htmlFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHTMLSupported() {
        return false;
    }

    protected String getHTMLData() {
        return null;
    }

    protected boolean isPlainFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = plainFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return false;
    }

    protected String getPlainData() {
        return null;
    }

    protected boolean isStringFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = stringFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            BasicGraphTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            BasicGraphTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            BasicGraphTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            BasicGraphTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            BasicGraphTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            BasicGraphTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            BasicGraphTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            BasicGraphTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
        }
    }
}

