/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.CayenneContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.graph.ChildDiffLoader;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class CayenneContextChildDiffLoader
extends ChildDiffLoader {
    public CayenneContextChildDiffLoader(CayenneContext context) {
        super(context);
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        super.nodePropertyChanged(nodeId, property, oldValue, newValue);
        Persistent object = (Persistent)this.context.getGraphManager().getNode(nodeId);
        this.context.propertyChanged(object, property, oldValue, newValue);
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        final Persistent source = this.findObject(nodeId);
        final Persistent target = this.findObject(targetNodeId);
        if (target == null) {
            return;
        }
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        ArcProperty property = (ArcProperty)descriptor.getProperty(arcId.toString());
        property.visit(new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                return false;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                property.addTargetDirectly(source, target);
                return false;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                property.setTarget(source, target, false);
                return false;
            }
        });
        this.context.propertyChanged(source, (String)arcId, null, target);
    }

    @Override
    public void arcDeleted(Object nodeId, final Object targetNodeId, Object arcId) {
        final Persistent source = this.findObject(nodeId);
        if (source == null) {
            return;
        }
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        PropertyDescriptor property = descriptor.getProperty(arcId.toString());
        final Persistent[] target = new Persistent[]{this.findObject(targetNodeId)};
        property.visit(new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                return false;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                if (target[0] == null) {
                    target[0] = CayenneContextChildDiffLoader.this.findObjectInCollection(targetNodeId, property.readProperty(source));
                }
                if (target[0] != null) {
                    property.removeTargetDirectly(source, target[0]);
                }
                return false;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                property.setTarget(source, null, false);
                return false;
            }
        });
        this.context.propertyChanged(source, (String)arcId, target[0], null);
    }
}

