package org.apache.cayenne.testdo.inheritance_with_enum.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.testdo.inheritance_with_enum.Dependent;

/**
 * Class _Root was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Root extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String ID_PK_COLUMN = "id";

    public static final Property<String> NAME = Property.create("name", String.class);
    public static final Property<Short> TYPE = Property.create("type", Short.class);
    public static final Property<List<Dependent>> DEPENDENTS = Property.create("dependents", List.class);

    protected String name;
    protected short type;

    protected Object dependents;

    public void setName(String name) {
        beforePropertyWrite("name", this.name, name);
        this.name = name;
    }

    public String getName() {
        beforePropertyRead("name");
        return this.name;
    }

    public void setType(short type) {
        beforePropertyWrite("type", this.type, type);
        this.type = type;
    }

    public short getType() {
        beforePropertyRead("type");
        return this.type;
    }

    public void addToDependents(Dependent obj) {
        addToManyTarget("dependents", obj, true);
    }

    public void removeFromDependents(Dependent obj) {
        removeToManyTarget("dependents", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Dependent> getDependents() {
        return (List<Dependent>)readProperty("dependents");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "name":
                return this.name;
            case "type":
                return this.type;
            case "dependents":
                return this.dependents;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "name":
                this.name = (String)val;
                break;
            case "type":
                this.type = val == null ? 0 : (short)val;
                break;
            case "dependents":
                this.dependents = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.name);
        out.writeShort(this.type);
        out.writeObject(this.dependents);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.name = (String)in.readObject();
        this.type = in.readShort();
        this.dependents = in.readObject();
    }

}
