/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.editor.dbimport.DatabaseSchemaLoader;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.editor.dbimport.DraggableTreePanel;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadDbSchemaAction
extends CayenneAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadDbSchemaAction.class);
    private static final String ICON_NAME = "icon-dbi-refresh.png";
    private static final String ACTION_NAME = "Refresh Db Schema";
    private DraggableTreePanel draggableTreePanel;

    LoadDbSchemaAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public void performAction(ActionEvent e) {
        this.performAction(e, null);
    }

    public void performAction(ActionEvent e, TreePath tablePath) {
        DbImportView rootParent = (DbImportView)this.draggableTreePanel.getParent().getParent();
        rootParent.getLoadDbSchemaProgress().setVisible(true);
        rootParent.getLoadDbSchemaButton().setEnabled(false);
        Thread thread = new Thread(() -> {
            this.setEnabled(false);
            rootParent.lockToolbarButtons();
            this.draggableTreePanel.getMoveButton().setEnabled(false);
            this.draggableTreePanel.getMoveInvertButton().setEnabled(false);
            try {
                ReverseEngineering databaseReverseEngineering;
                DBConnectionInfo connectionInfo;
                if (this.datamapPrefNotExist()) {
                    DataSourceWizard connectWizard = new DataSourceWizard(this.getProjectController(), "Load Db Schema");
                    if (!connectWizard.startupAction()) {
                        return;
                    }
                    connectionInfo = connectWizard.getConnectionInfo();
                    this.saveConnectionInfo(connectWizard);
                } else {
                    connectionInfo = this.getConnectionInfoFromPreferences();
                }
                if (tablePath != null) {
                    databaseReverseEngineering = new DatabaseSchemaLoader().loadColumns(connectionInfo, this.getApplication().getClassLoadingService(), tablePath);
                    this.draggableTreePanel.getSourceTree().updateTableColumns(databaseReverseEngineering);
                } else {
                    databaseReverseEngineering = new DatabaseSchemaLoader().load(connectionInfo, this.getApplication().getClassLoadingService(), rootParent.getTableTypes());
                    this.draggableTreePanel.getSourceTree().setEnabled(true);
                    this.draggableTreePanel.getSourceTree().translateReverseEngineeringToTree(databaseReverseEngineering, true);
                    this.draggableTreePanel.bindReverseEngineeringToDatamap(this.getProjectController().getCurrentDataMap(), databaseReverseEngineering);
                    ((DbImportModel)this.draggableTreePanel.getSourceTree().getModel()).reload();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Application.getFrame(), ex.getMessage(), "Error loading db schema", 0);
                LOGGER.warn("Error loading db schema", ex);
            }
            finally {
                rootParent.getLoadDbSchemaButton().setEnabled(true);
                rootParent.getLoadDbSchemaProgress().setVisible(false);
                rootParent.unlockToolbarButtons();
            }
        });
        thread.start();
    }

    private boolean datamapPrefNotExist() {
        Preferences dataMapPreference = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap()).getCurrentPreference();
        return dataMapPreference == null || dataMapPreference.get("url", null) == null;
    }

    private DBConnectionInfo getConnectionInfoFromPreferences() {
        DBConnectionInfo connectionInfo = new DBConnectionInfo();
        DataMapDefaults dataMapDefaults = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap());
        connectionInfo.setDbAdapter(dataMapDefaults.getCurrentPreference().get("dbAdapter", null));
        connectionInfo.setUrl(dataMapDefaults.getCurrentPreference().get("url", null));
        connectionInfo.setUserName(dataMapDefaults.getCurrentPreference().get("userName", null));
        connectionInfo.setPassword(dataMapDefaults.getCurrentPreference().get("password", null));
        connectionInfo.setJdbcDriver(dataMapDefaults.getCurrentPreference().get("jdbcDriver", null));
        return connectionInfo;
    }

    private void saveConnectionInfo(DataSourceWizard connectWizard) {
        DataMapDefaults dataMapDefaults = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap());
        String dbAdapter = connectWizard.getConnectionInfo().getDbAdapter();
        if (dbAdapter != null) {
            dataMapDefaults.getCurrentPreference().put("dbAdapter", connectWizard.getConnectionInfo().getDbAdapter());
        } else {
            dataMapDefaults.getCurrentPreference().remove("dbAdapter");
        }
        dataMapDefaults.getCurrentPreference().put("url", connectWizard.getConnectionInfo().getUrl());
        dataMapDefaults.getCurrentPreference().put("userName", connectWizard.getConnectionInfo().getUserName());
        dataMapDefaults.getCurrentPreference().put("password", connectWizard.getConnectionInfo().getPassword());
        dataMapDefaults.getCurrentPreference().put("jdbcDriver", connectWizard.getConnectionInfo().getJdbcDriver());
    }

    public void setDraggableTreePanel(DraggableTreePanel draggableTreePanel) {
        this.draggableTreePanel = draggableTreePanel;
    }
}

