/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.awt.Component;
import javax.swing.JLabel;
import org.apache.cayenne.modeler.editor.cgen.ClassesTabPanel;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorPane;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ImageRendererColumn;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.swing.TableBindingBuilder;

public class ClassesTabController
extends CayenneController {
    protected ClassesTabPanel view = new ClassesTabPanel();
    protected ObjectBinding tableBinding;
    private BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);

    public ClassesTabController(CodeGeneratorControllerBase parent) {
        super(parent);
    }

    public void startup() {
        this.initBindings();
        this.classSelectedAction();
    }

    protected CodeGeneratorControllerBase getParentController() {
        return (CodeGeneratorControllerBase)this.getParent();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.builder.bindToAction(((CodeGeneratorPane)this.parent.getView()).getCheckAll(), "checkAllAction()");
        TableBindingBuilder tableBuilder = new TableBindingBuilder(this.builder);
        tableBuilder.addColumn("", "parent.setCurrentClass(#item), selected", Boolean.class, true, Boolean.TRUE);
        tableBuilder.addColumn("Class", "parent.getItemName(#item)", JLabel.class, false, "XXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableBuilder.addColumn("Comments, Warnings", "parent.getProblem(#item)", String.class, false, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.tableBinding = tableBuilder.bindToTable(this.view.getTable(), "parent.classes");
        this.view.getTable().getColumnModel().getColumn(1).setCellRenderer(new ImageRendererColumn());
    }

    public boolean isSelected() {
        return this.getParentController().isSelected();
    }

    public void setSelected(boolean selected) {
        this.getParentController().setSelected(selected);
        this.classSelectedAction();
    }

    public void classSelectedAction() {
        int selectedCount = this.getParentController().getSelectedEntitiesSize() + this.getParentController().getSelectedEmbeddablesSize() + (this.getParentController().isDataMapSelected() ? 1 : 0);
        if (selectedCount == 0) {
            this.getParentController().enableGenerateButton(false);
        } else {
            this.getParentController().enableGenerateButton(true);
        }
        if (selectedCount < this.getParentController().getClasses().size()) {
            ((CodeGeneratorPane)this.parent.getView()).getCheckAll().setSelected(false);
        } else if (selectedCount == this.getParentController().getClasses().size()) {
            ((CodeGeneratorPane)this.parent.getView()).getCheckAll().setSelected(true);
        }
        this.getParentController().updateSelectedEntities();
    }

    public void checkAllAction() {
        if (this.getParentController().updateSelection(((CodeGeneratorPane)this.parent.getView()).getCheckAll().isSelected() ? o -> true : o -> false)) {
            this.tableBinding.updateView();
            this.getParentController().updateSelectedEntities();
            if (((CodeGeneratorPane)this.parent.getView()).getCheckAll().isSelected()) {
                this.getParentController().enableGenerateButton(true);
            } else {
                this.getParentController().enableGenerateButton(false);
            }
        }
    }
}

