/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;

public class DatabaseSchemaLoader {
    private static final String INCLUDE_ALL_PATTERN = "%";
    private ReverseEngineering databaseReverseEngineering = new ReverseEngineering();

    public ReverseEngineering load(DBConnectionInfo connectionInfo, ClassLoadingService loadingService, String[] tableTypesFromConfig) throws Exception {
        DbAdapter dbAdapter = connectionInfo.makeAdapter(loadingService);
        try (Connection connection = connectionInfo.makeDataSource(loadingService).getConnection();){
            String[] stringArray;
            if (tableTypesFromConfig != null && tableTypesFromConfig.length != 0) {
                stringArray = tableTypesFromConfig;
            } else {
                String[] stringArray2 = new String[7];
                stringArray2[0] = "TABLE";
                stringArray2[1] = "VIEW";
                stringArray2[2] = "SYSTEM TABLE";
                stringArray2[3] = "GLOBAL TEMPORARY";
                stringArray2[4] = "LOCAL TEMPORARY";
                stringArray2[5] = "ALIAS";
                stringArray = stringArray2;
                stringArray2[6] = "SYNONYM";
            }
            String[] types = stringArray;
            this.processCatalogs(connection, types, dbAdapter);
        }
        this.sort();
        return this.databaseReverseEngineering;
    }

    private void sort() {
        this.databaseReverseEngineering.getCatalogs().forEach(catalog -> {
            catalog.getSchemas().forEach(this::sort);
            this.sort((FilterContainer)catalog);
        });
        this.sort(this.databaseReverseEngineering);
    }

    private void sort(FilterContainer filterContainer) {
        Comparator<PatternParam> comparator = Comparator.comparing(PatternParam::getPattern);
        filterContainer.getIncludeTables().sort(comparator);
        filterContainer.getIncludeTables().forEach(table -> table.getIncludeColumns().sort(comparator));
        filterContainer.getIncludeProcedures().sort(comparator);
    }

    private void processCatalogs(Connection connection, String[] types, DbAdapter dbAdapter) throws SQLException {
        try (ResultSet rsCatalog = connection.getMetaData().getCatalogs();){
            boolean hasCatalogs = false;
            List<String> systemCatalogs = dbAdapter.getSystemCatalogs();
            while (rsCatalog.next()) {
                hasCatalogs = true;
                String catalog = rsCatalog.getString("TABLE_CAT");
                if (systemCatalogs.contains(catalog)) continue;
                this.processSchemas(connection, types, catalog, dbAdapter);
            }
            if (!hasCatalogs) {
                this.processSchemas(connection, types, null, dbAdapter);
            }
        }
    }

    private void processSchemas(Connection connection, String[] types, String catalog, DbAdapter dbAdapter) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet rsSchema = metaData.getSchemas(catalog, null);){
            boolean hasSchemas = false;
            List<String> systemSchemas = dbAdapter.getSystemSchemas();
            while (rsSchema.next()) {
                hasSchemas = true;
                String schema = rsSchema.getString("TABLE_SCHEM");
                if (systemSchemas.contains(schema)) continue;
                ResultSet resultSet = metaData.getTables(catalog, schema, INCLUDE_ALL_PATTERN, types);
                this.packTable(resultSet);
                this.packProcedures(connection);
            }
            if (!hasSchemas) {
                ResultSet resultSet = metaData.getTables(catalog, null, INCLUDE_ALL_PATTERN, types);
                this.packTable(resultSet);
                this.packProcedures(connection);
            }
        }
    }

    public ReverseEngineering loadColumns(DBConnectionInfo connectionInfo, ClassLoadingService loadingService, TreePath path) throws SQLException {
        int pathIndex = 1;
        String catalogName = null;
        String schemaName = null;
        Object userObject = this.getUserObject(path, pathIndex);
        if (userObject instanceof Catalog) {
            catalogName = ((Catalog)userObject).getName();
            if ((userObject = this.getUserObject(path, ++pathIndex)) instanceof Schema) {
                schemaName = ((Schema)userObject).getName();
                userObject = this.getUserObject(path, ++pathIndex);
            }
        } else if (userObject instanceof Schema) {
            schemaName = ((Schema)userObject).getName();
            userObject = this.getUserObject(path, ++pathIndex);
        }
        String tableName = this.processTable(userObject);
        try (Connection connection = connectionInfo.makeDataSource(loadingService).getConnection();
             ResultSet rs = connection.getMetaData().getColumns(catalogName, schemaName, tableName, null);){
            while (rs.next()) {
                String column = rs.getString("COLUMN_NAME");
                this.packTable(tableName, catalogName, schemaName, column);
            }
        }
        this.sort();
        return this.databaseReverseEngineering;
    }

    private Object getUserObject(TreePath path, int pathIndex) {
        return ((DbImportTreeNode)path.getPathComponent(pathIndex)).getUserObject();
    }

    private String processTable(Object userObject) {
        if (userObject instanceof IncludeTable) {
            return ((IncludeTable)userObject).getPattern();
        }
        return null;
    }

    private void packProcedures(Connection connection) throws SQLException {
        ResultSet procResultSet;
        List<Catalog> catalogs = this.databaseReverseEngineering.getCatalogs();
        for (Catalog catalog : catalogs) {
            List<Schema> schemas = catalog.getSchemas();
            if (!schemas.isEmpty()) {
                for (Schema schema : schemas) {
                    ResultSet procResultSet2 = this.getProcedures(connection, catalog.getName(), schema.getName());
                    this.packFunction(procResultSet2, schema);
                }
                continue;
            }
            procResultSet = this.getProcedures(connection, catalog.getName(), null);
            this.packFunction(procResultSet, catalog);
        }
        List<Schema> schemas = this.databaseReverseEngineering.getSchemas();
        for (Schema schema : schemas) {
            procResultSet = this.getProcedures(connection, null, schema.getName());
            this.packFunction(procResultSet, schema);
        }
    }

    private ResultSet getProcedures(Connection connection, String catalog, String schema) throws SQLException {
        return connection.getMetaData().getProcedures(catalog, schema, INCLUDE_ALL_PATTERN);
    }

    private void packFunction(ResultSet resultSet, FilterContainer filterContainer) throws SQLException {
        while (resultSet.next()) {
            IncludeProcedure includeProcedure = new IncludeProcedure(resultSet.getString("PROCEDURE_NAME"));
            if (filterContainer.getIncludeProcedures().contains(includeProcedure)) continue;
            filterContainer.addIncludeProcedure(includeProcedure);
        }
    }

    private void packTable(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            String tableName = resultSet.getString("TABLE_NAME");
            String schemaName = resultSet.getString("TABLE_SCHEM");
            String catalogName = resultSet.getString("TABLE_CAT");
            this.packTable(tableName, catalogName, schemaName, null);
        }
    }

    private void packTable(String tableName, String catalogName, String schemaName, String columnName) {
        FilterContainer filterContainer;
        IncludeTable table = new IncludeTable();
        table.setPattern(tableName);
        if (catalogName == null && schemaName == null) {
            if (!this.databaseReverseEngineering.getIncludeTables().contains(table)) {
                this.databaseReverseEngineering.addIncludeTable(table);
            }
            return;
        }
        if (catalogName != null && schemaName == null) {
            Catalog parentCatalog = this.getCatalogByName(this.databaseReverseEngineering.getCatalogs(), catalogName);
            if (parentCatalog == null) {
                parentCatalog = new Catalog();
                parentCatalog.setName(catalogName);
                this.databaseReverseEngineering.addCatalog(parentCatalog);
            }
            filterContainer = parentCatalog;
        } else if (catalogName == null) {
            Schema parentSchema = this.getSchemaByName(this.databaseReverseEngineering.getSchemas(), schemaName);
            if (parentSchema == null) {
                parentSchema = new Schema();
                parentSchema.setName(schemaName);
                this.databaseReverseEngineering.addSchema(parentSchema);
            }
            filterContainer = parentSchema;
        } else {
            Schema parentSchema;
            Catalog parentCatalog = this.getCatalogByName(this.databaseReverseEngineering.getCatalogs(), catalogName);
            if (parentCatalog != null) {
                parentSchema = this.getSchemaByName(parentCatalog.getSchemas(), schemaName);
                if (parentSchema == null) {
                    parentSchema = new Schema();
                    parentSchema.setName(schemaName);
                    parentCatalog.addSchema(parentSchema);
                }
            } else {
                parentCatalog = new Catalog();
                parentCatalog.setName(catalogName);
                parentSchema = new Schema();
                parentSchema.setName(schemaName);
                parentCatalog.addSchema(parentSchema);
                this.databaseReverseEngineering.addCatalog(parentCatalog);
            }
            filterContainer = parentSchema;
        }
        this.addTable(filterContainer, table);
        this.addColumn(filterContainer, table, columnName);
    }

    private void addTable(FilterContainer parentFilter, IncludeTable table) {
        if (!parentFilter.getIncludeTables().contains(table)) {
            parentFilter.addIncludeTable(table);
        }
    }

    private void addColumn(FilterContainer filterContainer, IncludeTable table, String columnName) {
        IncludeTable foundTable = this.getTableByName(filterContainer.getIncludeTables(), table.getPattern());
        IncludeTable includeTable = table = foundTable != null ? foundTable : table;
        if (columnName != null) {
            IncludeColumn includeColumn = new IncludeColumn(columnName);
            table.addIncludeColumn(includeColumn);
        }
    }

    private Catalog getCatalogByName(Collection<Catalog> catalogs, String catalogName) {
        for (Catalog catalog : catalogs) {
            if (!catalog.getName().equals(catalogName)) continue;
            return catalog;
        }
        return null;
    }

    private IncludeTable getTableByName(Collection<IncludeTable> tables, String catalogName) {
        for (IncludeTable table : tables) {
            if (!table.getPattern().equals(catalogName)) continue;
            return table;
        }
        return null;
    }

    private Schema getSchemaByName(Collection<Schema> schemas, String schemaName) {
        for (Schema schema : schemas) {
            if (!schema.getName().equals(schemaName)) continue;
            return schema;
        }
        return null;
    }
}

