/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.Node;

public class SQLiteQualifierTranslator
extends QualifierTranslator {
    public SQLiteQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    @Override
    public void endNode(Expression node, Expression parentNode) {
        super.endNode(node, parentNode);
        if (node.getType() == 45 && "LOCATE".equals(((ASTFunctionCall)node).getFunctionName())) {
            this.swapNodeChildren((ASTFunctionCall)node, 0, 1);
        }
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": 
            case "CONCAT": {
                break;
            }
            case "SUBSTRING": {
                this.out.append("SUBSTR");
                break;
            }
            case "LOCATE": {
                this.out.append("INSTR");
                this.swapNodeChildren(functionExpression, 0, 1);
                break;
            }
            default: {
                super.appendFunction(functionExpression);
            }
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": {
                this.out.append(" % ");
                break;
            }
            case "CONCAT": {
                this.out.append(" || ");
                break;
            }
            default: {
                super.appendFunctionArgDivider(functionExpression);
            }
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": {
                this.out.delete(this.out.length() - 3, this.out.length());
                break;
            }
            case "CONCAT": {
                this.out.delete(this.out.length() - 4, this.out.length());
                break;
            }
            default: {
                super.clearLastFunctionArgDivider(functionExpression);
            }
        }
        if (functionExpression instanceof ASTExtract) {
            this.out.append(") as integer)");
        }
    }

    @Override
    protected boolean parenthesisNeeded(Expression node, Expression parentNode) {
        if (node.getType() == 45 && node instanceof ASTExtract) {
            return false;
        }
        return super.parenthesisNeeded(node, parentNode);
    }

    @Override
    protected void appendExtractFunction(ASTExtract functionExpression) {
        this.out.append("cast(strftime(");
        switch (functionExpression.getPart()) {
            case YEAR: {
                this.out.append("'%Y'");
                break;
            }
            case MONTH: {
                this.out.append("'%m'");
                break;
            }
            case WEEK: {
                this.out.append("'%W'");
                break;
            }
            case DAY: 
            case DAY_OF_MONTH: {
                this.out.append("'%d'");
                break;
            }
            case DAY_OF_WEEK: {
                this.out.append("'%w'");
                break;
            }
            case DAY_OF_YEAR: {
                this.out.append("'%j'");
                break;
            }
            case HOUR: {
                this.out.append("'%H'");
                break;
            }
            case MINUTE: {
                this.out.append("'%M'");
                break;
            }
            case SECOND: {
                this.out.append("'%S'");
            }
        }
        this.out.append(", ");
    }

    private void swapNodeChildren(Node node, int i, int j) {
        Node ni = node.jjtGetChild(i);
        Node nj = node.jjtGetChild(j);
        node.jjtAddChild(ni, j);
        node.jjtAddChild(nj, i);
    }
}

