/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.util.Util;

public class Invocation {
    private WeakReference _target;
    private Method _method;
    private Class[] _parameterTypes;
    private int _hashCode;

    private Invocation() {
    }

    public Invocation(Object target, String methodName) throws NoSuchMethodException {
        this(target, methodName, (Class[])null);
    }

    public Invocation(Object target, String methodName, Class parameterType) throws NoSuchMethodException {
        this(target, methodName, new Class[]{parameterType});
    }

    public Invocation(Object target, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        if (target == null) {
            throw new IllegalArgumentException("target argument must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("method name must not be null");
        }
        if (parameterTypes != null) {
            if (parameterTypes.length > 0) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i] != null) continue;
                    throw new IllegalArgumentException("parameter type[" + i + "] must not be null");
                }
            } else {
                throw new IllegalArgumentException("parameter types must not be empty");
            }
        }
        this._method = this.lookupMethodInHierarchy(target.getClass(), methodName, parameterTypes);
        if (this._method == null) {
            throw new NoSuchMethodException("No such method: " + target.getClass().getName() + "." + methodName);
        }
        if (!Util.isAccessible(this._method)) {
            this._method.setAccessible(true);
        }
        this._hashCode = 31 * target.hashCode() + this._method.hashCode();
        this._parameterTypes = parameterTypes;
        this._target = new WeakReference<Object>(target);
    }

    Method lookupMethodInHierarchy(Class objectClass, String methodName, Class[] parameterTypes) throws SecurityException, NoSuchMethodException {
        try {
            return objectClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class superClass = objectClass.getSuperclass();
            if (superClass == null || superClass.getName().equals(Object.class.getName())) {
                throw e;
            }
            return this.lookupMethodInHierarchy(superClass, methodName, parameterTypes);
        }
    }

    public boolean fire() {
        return this.fire(null);
    }

    public boolean fire(Object argument) {
        return this.fire(new Object[]{argument});
    }

    public boolean fire(Object[] arguments) {
        Object currentTarget;
        if (this._parameterTypes == null) {
            if (arguments != null) {
                throw new IllegalArgumentException("arguments unexpectedly != null");
            }
        } else {
            if (arguments == null) {
                throw new IllegalArgumentException("arguments must not be null");
            }
            if (this._parameterTypes.length != arguments.length) {
                throw new IllegalArgumentException("inconsistent number of arguments: expected" + this._parameterTypes.length + ", got " + arguments.length);
            }
        }
        if ((currentTarget = this._target.get()) == null) {
            return false;
        }
        try {
            this._method.invoke(currentTarget, arguments);
            return true;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new CayenneRuntimeException(cause);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            Invocation otherInvocation = (Invocation)obj;
            if (this._method.equals(otherInvocation.getMethod())) {
                Object otherTarget = otherInvocation.getTarget();
                Object target = this._target.get();
                if (target == null && otherTarget == null) {
                    return true;
                }
                if (target == null && otherTarget != null) {
                    return false;
                }
                if (target != null) {
                    return target.equals(otherTarget);
                }
            }
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public Method getMethod() {
        return this._method;
    }

    public Object getTarget() {
        return this._target.get();
    }

    public Class[] getParameterTypes() {
        return this._parameterTypes;
    }
}

