package org.apache.cayenne.testdo.relationships.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.relationships.FkOfDifferentType;
import org.apache.cayenne.testdo.relationships.MeaningfulFK;
import org.apache.cayenne.testdo.relationships.ReflexiveAndToOne;

/**
 * Class _RelationshipHelper was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _RelationshipHelper extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String RELATIONSHIP_HELPER_ID_PK_COLUMN = "RELATIONSHIP_HELPER_ID";

    public static final StringProperty<String> NAME = PropertyFactory.createString("name", String.class);
    public static final ListProperty<FkOfDifferentType> FKS_OF_DIFFERENT_TYPE = PropertyFactory.createList("fksOfDifferentType", FkOfDifferentType.class);
    public static final ListProperty<MeaningfulFK> MEANIGFUL_FKS = PropertyFactory.createList("meanigfulFKs", MeaningfulFK.class);
    public static final ListProperty<ReflexiveAndToOne> REFLEXIVE_AND_TO_ONE_ARRAY = PropertyFactory.createList("reflexiveAndToOneArray", ReflexiveAndToOne.class);

    protected String name;

    protected Object fksOfDifferentType;
    protected Object meanigfulFKs;
    protected Object reflexiveAndToOneArray;

    public void setName(String name) {
        beforePropertyWrite("name", this.name, name);
        this.name = name;
    }

    public String getName() {
        beforePropertyRead("name");
        return this.name;
    }

    public void addToFksOfDifferentType(FkOfDifferentType obj) {
        addToManyTarget("fksOfDifferentType", obj, true);
    }

    public void removeFromFksOfDifferentType(FkOfDifferentType obj) {
        removeToManyTarget("fksOfDifferentType", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<FkOfDifferentType> getFksOfDifferentType() {
        return (List<FkOfDifferentType>)readProperty("fksOfDifferentType");
    }

    public void addToMeanigfulFKs(MeaningfulFK obj) {
        addToManyTarget("meanigfulFKs", obj, true);
    }

    public void removeFromMeanigfulFKs(MeaningfulFK obj) {
        removeToManyTarget("meanigfulFKs", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<MeaningfulFK> getMeanigfulFKs() {
        return (List<MeaningfulFK>)readProperty("meanigfulFKs");
    }

    public void addToReflexiveAndToOneArray(ReflexiveAndToOne obj) {
        addToManyTarget("reflexiveAndToOneArray", obj, true);
    }

    public void removeFromReflexiveAndToOneArray(ReflexiveAndToOne obj) {
        removeToManyTarget("reflexiveAndToOneArray", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<ReflexiveAndToOne> getReflexiveAndToOneArray() {
        return (List<ReflexiveAndToOne>)readProperty("reflexiveAndToOneArray");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "name":
                return this.name;
            case "fksOfDifferentType":
                return this.fksOfDifferentType;
            case "meanigfulFKs":
                return this.meanigfulFKs;
            case "reflexiveAndToOneArray":
                return this.reflexiveAndToOneArray;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "name":
                this.name = (String)val;
                break;
            case "fksOfDifferentType":
                this.fksOfDifferentType = val;
                break;
            case "meanigfulFKs":
                this.meanigfulFKs = val;
                break;
            case "reflexiveAndToOneArray":
                this.reflexiveAndToOneArray = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.name);
        out.writeObject(this.fksOfDifferentType);
        out.writeObject(this.meanigfulFKs);
        out.writeObject(this.reflexiveAndToOneArray);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.name = (String)in.readObject();
        this.fksOfDifferentType = in.readObject();
        this.meanigfulFKs = in.readObject();
        this.reflexiveAndToOneArray = in.readObject();
    }

}
