/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.util.Util;

public class DataRow
extends HashMap<String, Object> {
    private static AtomicLong currentVersion = new AtomicLong(-9223372036854775807L);
    protected long version = currentVersion.getAndIncrement();
    protected long replacesVersion = Long.MIN_VALUE;
    protected String entityName;

    public DataRow(Map<String, ?> map) {
        super(map);
    }

    public DataRow(int initialCapacity) {
        super(initialCapacity);
    }

    public long getVersion() {
        return this.version;
    }

    public long getReplacesVersion() {
        return this.replacesVersion;
    }

    public void setReplacesVersion(long replacesVersion) {
        this.replacesVersion = replacesVersion;
    }

    public DataRow applyDiff(DataRow diff) {
        DataRow merged = new DataRow(this);
        for (Map.Entry entry : diff.entrySet()) {
            merged.put((String)entry.getKey(), entry.getValue());
        }
        return merged;
    }

    public DataRow createDiff(DataRow row) {
        HashMap diff = null;
        for (Map.Entry entry : this.entrySet()) {
            Object rowValue;
            String key = (String)entry.getKey();
            Object currentValue = entry.getValue();
            if (Util.nullSafeEquals(currentValue, rowValue = row.get(key))) continue;
            if (diff == null) {
                diff = new DataRow(this.size());
            }
            diff.put(key, rowValue);
        }
        return diff;
    }

    public ObjectId createTargetObjectId(String entityName, DbRelationship relationship) {
        if (relationship.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' can have a target ObjectId.", new Object[0]);
        }
        Map<String, Object> target = relationship.targetPkSnapshotWithSrcSnapshot(this);
        return target != null ? ObjectId.of(entityName, target) : null;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("values", super.toString()).append(" version", this.version).append(" replaces", this.replacesVersion).toString();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }
}

