/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.value;

import java.util.Objects;
import org.apache.cayenne.value.json.JsonUtils;
import org.apache.cayenne.value.json.MalformedJsonException;

public class Json {
    private final String json;

    public Json(String json) {
        if (Json.isBlank(json)) {
            throw new MalformedJsonException("Unexpected EOF");
        }
        this.json = json;
    }

    public String getRawJson() {
        return this.json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Json other = (Json)o;
        return JsonUtils.compare(this.json, other.json);
    }

    public int hashCode() {
        return Objects.hash(this.json);
    }

    public String toString() {
        return "JSON value: " + this.json;
    }

    private static boolean isBlank(String json) {
        for (char character : json.toCharArray()) {
            if (Character.isWhitespace(character)) continue;
            return false;
        }
        return true;
    }
}

