package org.apache.cayenne.testdo.inheritance_people.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.inheritance_people.ClientCompany;
import org.apache.cayenne.testdo.inheritance_people.CustomerRepresentative;

/**
 * Class _ClientCompany was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _ClientCompany extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<ClientCompany> SELF = PropertyFactory.createSelf(ClientCompany.class);

    public static final NumericIdProperty<Integer> CLIENT_COMPANY_ID_PK_PROPERTY = PropertyFactory.createNumericId("CLIENT_COMPANY_ID", "ClientCompany", Integer.class);
    public static final String CLIENT_COMPANY_ID_PK_COLUMN = "CLIENT_COMPANY_ID";

    public static final StringProperty<String> NAME = PropertyFactory.createString("name", String.class);
    public static final ListProperty<CustomerRepresentative> REPRESENTATIVES = PropertyFactory.createList("representatives", CustomerRepresentative.class);

    protected String name;

    protected Object representatives;

    public void setName(String name) {
        beforePropertyWrite("name", this.name, name);
        this.name = name;
    }

    public String getName() {
        beforePropertyRead("name");
        return this.name;
    }

    public void addToRepresentatives(CustomerRepresentative obj) {
        addToManyTarget("representatives", obj, true);
    }

    public void removeFromRepresentatives(CustomerRepresentative obj) {
        removeToManyTarget("representatives", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<CustomerRepresentative> getRepresentatives() {
        return (List<CustomerRepresentative>)readProperty("representatives");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "name":
                return this.name;
            case "representatives":
                return this.representatives;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "name":
                this.name = (String)val;
                break;
            case "representatives":
                this.representatives = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.name);
        out.writeObject(this.representatives);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.name = (String)in.readObject();
        this.representatives = in.readObject();
    }

}
