package org.apache.cayenne.testdo.numeric_types.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.testdo.numeric_types.LongEntity;

/**
 * Class _LongEntity was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _LongEntity extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<LongEntity> SELF = PropertyFactory.createSelf(LongEntity.class);

    public static final NumericIdProperty<Integer> ID_PK_PROPERTY = PropertyFactory.createNumericId("ID", "LongEntity", Integer.class);
    public static final String ID_PK_COLUMN = "ID";

    public static final NumericProperty<Long> LONG_FIELD = PropertyFactory.createNumeric("longField", Long.class);

    protected Long longField;


    public void setLongField(Long longField) {
        beforePropertyWrite("longField", this.longField, longField);
        this.longField = longField;
    }

    public Long getLongField() {
        beforePropertyRead("longField");
        return this.longField;
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "longField":
                return this.longField;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "longField":
                this.longField = (Long)val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.longField);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.longField = (Long)in.readObject();
    }

}
