/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.lifecycle.id.EntityIdCoder;
import org.apache.cayenne.lifecycle.relationship.ObjectIdBatchSourceItem;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Query;

class ObjectIdBatchFault {
    private ObjectContext context;
    private List<ObjectIdBatchSourceItem> sources;
    private volatile Map<String, Object> resolved;

    ObjectIdBatchFault(ObjectContext context, List<ObjectIdBatchSourceItem> sources) {
        this.context = context;
        this.sources = sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> getObjects() {
        if (this.resolved == null) {
            ObjectIdBatchFault objectIdBatchFault = this;
            synchronized (objectIdBatchFault) {
                if (this.resolved == null) {
                    this.resolved = this.fetchObjects();
                }
            }
        }
        return this.resolved;
    }

    private Map<String, Object> fetchObjects() {
        EntityIdCoder coder;
        if (this.sources == null) {
            return Collections.emptyMap();
        }
        EntityResolver resolver = this.context.getEntityResolver();
        if (this.sources.size() == 1) {
            String uuid = this.sources.get(0).getId();
            String entityName = EntityIdCoder.getEntityName(uuid);
            ObjEntity entity = resolver.getObjEntity(entityName);
            ObjectId id = new EntityIdCoder(entity).toObjectId(uuid);
            Object object = Cayenne.objectForQuery((ObjectContext)this.context, (Query)new ObjectIdQuery(id));
            if (object == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(uuid, object);
        }
        HashMap<String, ObjectSelect> queriesByEntity = new HashMap<String, ObjectSelect>();
        HashMap<String, EntityIdCoder> codersByEntity = new HashMap<String, EntityIdCoder>();
        for (ObjectIdBatchSourceItem source : this.sources) {
            ObjectSelect query;
            String uuid = source.getId();
            String entityName = EntityIdCoder.getEntityName(uuid);
            coder = (EntityIdCoder)codersByEntity.get(entityName);
            if (coder == null) {
                coder = new EntityIdCoder(resolver.getObjEntity(entityName));
                codersByEntity.put(entityName, coder);
                query = ObjectSelect.query(Persistent.class, (String)entityName);
                queriesByEntity.put(entityName, query);
            } else {
                query = (ObjectSelect)queriesByEntity.get(entityName);
            }
            ObjectId id = coder.toObjectId(uuid);
            Expression idExp = ExpressionFactory.matchAllDbExp((Map)id.getIdSnapshot(), (int)3);
            query.or(new Expression[]{idExp});
        }
        int capacity = (int)Math.ceil((double)this.sources.size() / 0.75);
        HashMap<String, Object> results = new HashMap<String, Object>(capacity);
        for (ObjectSelect query : queriesByEntity.values()) {
            coder = (EntityIdCoder)codersByEntity.get(query.getEntityName());
            List objects = query.select(this.context);
            for (Persistent object : objects) {
                String uuid = coder.toStringId(object.getObjectId());
                results.put(uuid, object);
            }
        }
        return results;
    }
}

