/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.hsqldb.HSQLDBAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.resource.ResourceLocator;

public class HSQLDBNoSchemaAdapter
extends HSQLDBAdapter {
    public HSQLDBNoSchemaAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
    }

    @Override
    protected String getTableName(DbEntity entity) {
        return this.quotingStrategy.quotedIdentifier(entity, entity.getName());
    }

    @Override
    protected String getSchemaName(DbEntity entity) {
        return null;
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return Collections.singleton("DROP TABLE " + this.getTableName(table));
    }

    @Override
    public String createTable(DbEntity ent) {
        Object sql = super.createTable(ent);
        String fqnCreate = "CREATE CACHED TABLE " + super.getTableName(ent) + " (";
        if (sql != null && ((String)sql).toUpperCase().startsWith(fqnCreate)) {
            sql = "CREATE CACHED TABLE " + this.getTableName(ent) + " (" + ((String)sql).substring(fqnCreate.length());
        }
        return sql;
    }
}

