/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.validation;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.swing.components.tree.ChangeOptimizingTreeModel;
import org.apache.cayenne.swing.components.tree.CheckBoxNodeData;
import org.apache.cayenne.swing.components.tree.CheckBoxTree;

class InspectionCheckBoxTree
extends CheckBoxTree {
    private final Map<Inspection, TreePath> inspectionPathCache;

    private InspectionCheckBoxTree(TreeModel model, Map<Inspection, TreePath> inspectionPathCache) {
        super(model);
        this.inspectionPathCache = inspectionPathCache;
        this.labelTree.addMouseMotionListener(new ToolTipHandler(this.labelTree));
        this.checkBoxTree.addMouseMotionListener(new ToolTipHandler(this.checkBoxTree));
    }

    public void refreshEnabledInspections(Set<Inspection> enabledInspections) {
        TreeModel model = this.getModel();
        for (Map.Entry<Inspection, TreePath> inspectionPath : this.inspectionPathCache.entrySet()) {
            Inspection inspection = inspectionPath.getKey();
            TreePath path = inspectionPath.getValue();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            CheckBoxNodeData data = (CheckBoxNodeData)node.getUserObject();
            model.valueForPathChanged(path, data.withState(enabledInspections.contains((Object)inspection)));
        }
    }

    public void selectInspection(Inspection inspection) {
        this.getSelectionModel().setSelectionPath(this.inspectionPathCache.get((Object)inspection));
    }

    public static InspectionCheckBoxTree build() {
        HashMap<Inspection, TreePath> inspectionPathCache = new HashMap<Inspection, TreePath>();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        EnumMap<Inspection.Group, MutableTreeNode> groupNodes = new EnumMap<Inspection.Group, MutableTreeNode>(Inspection.Group.class);
        for (Inspection inspection : Inspection.values()) {
            MutableTreeNode groupNode = groupNodes.computeIfAbsent(inspection.group(), g -> InspectionCheckBoxTree.addChild(root, g));
            DefaultMutableTreeNode inspectionNode = InspectionCheckBoxTree.addChild(groupNode, (Object)inspection);
            inspectionPathCache.put(inspection, new TreePath(inspectionNode.getPath()));
        }
        ChangeOptimizingTreeModel model = new ChangeOptimizingTreeModel(root);
        return new InspectionCheckBoxTree(model, inspectionPathCache);
    }

    private static DefaultMutableTreeNode addChild(MutableTreeNode parent, Object value) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new CheckBoxNodeData(value, false));
        parent.insert(node, parent.getChildCount());
        return node;
    }

    private static class ToolTipHandler
    extends MouseMotionAdapter {
        private final JTree tree;
        private Object latestTarget;

        public ToolTipHandler(JTree tree) {
            this.tree = tree;
            ToolTipManager.sharedInstance().registerComponent(tree);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            TreePath closestPath = this.tree.getClosestPathForLocation(e.getX(), e.getY());
            if (closestPath == null || !(closestPath.getLastPathComponent() instanceof DefaultMutableTreeNode)) {
                this.tree.setToolTipText(null);
                toolTipManager.mousePressed(e);
                return;
            }
            DefaultMutableTreeNode component = (DefaultMutableTreeNode)closestPath.getLastPathComponent();
            if (component != this.latestTarget) {
                toolTipManager.mousePressed(e);
                this.latestTarget = component;
            }
            if (!(component.getUserObject() instanceof CheckBoxNodeData)) {
                this.tree.setToolTipText(null);
                return;
            }
            CheckBoxNodeData data = (CheckBoxNodeData)component.getUserObject();
            if (data.getValue() instanceof Inspection) {
                String description = ((Inspection)((Object)data.getValue())).description();
                this.tree.setToolTipText((String)(description.endsWith(".") ? description : description + "."));
            } else if (data.getValue() instanceof Inspection.Group) {
                this.tree.setToolTipText(((Inspection.Group)((Object)data.getValue())).readableName() + " inspections.");
            } else {
                this.tree.setToolTipText(null);
            }
        }
    }
}

