/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DbGeneratorPostprocessor;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbGenerator.class);
    protected DbAdapter adapter;
    protected DataMap map;
    protected DataDomain domain;
    protected JdbcEventLogger jdbcEventLogger;
    protected Map<String, Collection<String>> dropTables;
    protected Map<String, String> createTables;
    protected Map<String, List<String>> createConstraints;
    protected List<String> createPK;
    protected List<String> dropPK;
    protected List<DbEntity> dbEntitiesInInsertOrder;
    protected List<DbEntity> dbEntitiesRequiringAutoPK;
    protected boolean shouldDropTables;
    protected boolean shouldCreateTables;
    protected boolean shouldDropPKSupport;
    protected boolean shouldCreatePKSupport;
    protected boolean shouldCreateFKConstraints;
    protected ValidationResult failures;

    public DbGenerator(DbAdapter adapter, DataMap map, JdbcEventLogger logger) {
        this(adapter, map, logger, Collections.emptyList());
    }

    public DbGenerator(DbAdapter adapter, DataMap map, JdbcEventLogger logger, Collection<DbEntity> excludedEntities) {
        this(adapter, map, excludedEntities, null, logger);
    }

    public DbGenerator(DbAdapter adapter, DataMap map, Collection<DbEntity> excludedEntities, DataDomain domain, JdbcEventLogger logger) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter must not be null.");
        }
        if (map == null) {
            throw new IllegalArgumentException("DataMap must not be null.");
        }
        this.domain = domain;
        this.map = map;
        this.adapter = adapter;
        this.jdbcEventLogger = logger;
        this.prepareDbEntities(excludedEntities);
        this.resetToDefaults();
        this.buildStatements();
    }

    protected void resetToDefaults() {
        this.shouldDropTables = false;
        this.shouldDropPKSupport = false;
        this.shouldCreatePKSupport = true;
        this.shouldCreateTables = true;
        this.shouldCreateFKConstraints = true;
    }

    protected void buildStatements() {
        this.dropTables = new HashMap<String, Collection<String>>();
        this.createTables = new HashMap<String, String>();
        this.createConstraints = new HashMap<String, List<String>>();
        DbAdapter adapter = this.getAdapter();
        for (DbEntity dbe : this.dbEntitiesInInsertOrder) {
            String name = dbe.getName();
            this.dropTables.put(name, adapter.dropTableStatements(dbe));
            this.createTables.put(name, adapter.createTable(dbe));
            this.createConstraints.put(name, this.createConstraintsQueries(dbe));
        }
        PkGenerator pkGenerator = adapter.getPkGenerator();
        this.dropPK = pkGenerator.dropAutoPkStatements(this.dbEntitiesRequiringAutoPK);
        this.createPK = pkGenerator.createAutoPkStatements(this.dbEntitiesRequiringAutoPK);
    }

    public boolean isEmpty(boolean respectConfiguredSettings) {
        if (this.dbEntitiesInInsertOrder.isEmpty() && this.dbEntitiesRequiringAutoPK.isEmpty()) {
            return true;
        }
        if (!respectConfiguredSettings) {
            return false;
        }
        return !this.shouldDropTables && !this.shouldCreateTables && !this.shouldCreateFKConstraints && !this.shouldCreatePKSupport && !this.shouldDropPKSupport;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public List<String> configuredStatements() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.shouldDropTables) {
            ListIterator<DbEntity> it = this.dbEntitiesInInsertOrder.listIterator(this.dbEntitiesInInsertOrder.size());
            while (it.hasPrevious()) {
                DbEntity ent = it.previous();
                list.addAll(this.dropTables.get(ent.getName()));
            }
        }
        if (this.shouldCreateTables) {
            for (DbEntity ent : this.dbEntitiesInInsertOrder) {
                list.add(this.createTables.get(ent.getName()));
            }
        }
        if (this.shouldCreateFKConstraints) {
            for (DbEntity ent : this.dbEntitiesInInsertOrder) {
                List<String> fks = this.createConstraints.get(ent.getName());
                list.addAll(fks);
            }
        }
        if (this.shouldDropPKSupport) {
            list.addAll(this.dropPK);
        }
        if (this.shouldCreatePKSupport) {
            list.addAll(this.createPK);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runGenerator(DataSource ds) throws Exception {
        this.failures = null;
        try (Connection connection = ds.getConnection();){
            boolean autoCommit = connection.getAutoCommit();
            connection.setAutoCommit(true);
            try {
                if (this.shouldDropTables) {
                    ListIterator<DbEntity> it = this.dbEntitiesInInsertOrder.listIterator(this.dbEntitiesInInsertOrder.size());
                    while (it.hasPrevious()) {
                        Iterator<DbEntity> ent = it.previous();
                        for (String statement : this.dropTables.get(((Entity)((Object)ent)).getName())) {
                            this.safeExecute(connection, statement);
                        }
                    }
                }
                ArrayList<String> createdTables = new ArrayList<String>();
                if (this.shouldCreateTables) {
                    for (DbEntity ent : this.dbEntitiesInInsertOrder) {
                        this.safeExecute(connection, this.createTables.get(ent.getName()));
                        createdTables.add(ent.getName());
                    }
                }
                if (this.shouldCreateTables && this.shouldCreateFKConstraints) {
                    for (DbEntity ent : this.dbEntitiesInInsertOrder) {
                        if (!createdTables.contains(ent.getName())) continue;
                        List<String> fks = this.createConstraints.get(ent.getName());
                        for (String fk : fks) {
                            this.safeExecute(connection, fk);
                        }
                    }
                }
                if (this.shouldDropPKSupport) {
                    List<String> dropAutoPKSQL = this.getAdapter().getPkGenerator().dropAutoPkStatements(this.dbEntitiesRequiringAutoPK);
                    for (String sql : dropAutoPKSQL) {
                        this.safeExecute(connection, sql);
                    }
                }
                if (this.shouldCreatePKSupport) {
                    List<String> createAutoPKSQL = this.getAdapter().getPkGenerator().createAutoPkStatements(this.dbEntitiesRequiringAutoPK);
                    for (String sql : createAutoPKSQL) {
                        this.safeExecute(connection, sql);
                    }
                }
                new DbGeneratorPostprocessor().execute(connection, this.getAdapter());
            }
            finally {
                connection.setAutoCommit(autoCommit);
            }
        }
    }

    protected boolean safeExecute(Connection connection, String sql) {
        boolean bl;
        block9: {
            Statement statement = connection.createStatement();
            try {
                this.jdbcEventLogger.log(sql);
                statement.execute(sql);
                bl = true;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    if (this.failures == null) {
                        this.failures = new ValidationResult();
                    }
                    this.failures.addFailure(new SimpleValidationFailure(sql, ex.getMessage()));
                    this.jdbcEventLogger.logQueryError(ex);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public List<String> createConstraintsQueries(DbEntity table) {
        ArrayList<String> list = new ArrayList<String>();
        for (DbRelationship rel : table.getRelationships()) {
            String fk;
            String unique;
            DbRelationship reverse;
            if (rel.isToMany()) continue;
            if (this.domain != null) {
                DataMap srcMap = ((DbEntity)rel.getSourceEntity()).getDataMap();
                DataMap targetMap = rel.getTargetEntity().getDataMap();
                if (srcMap != null && targetMap != null && srcMap != targetMap && this.domain.lookupDataNode(srcMap) != this.domain.lookupDataNode(targetMap)) continue;
            }
            if (!rel.isToPK() || rel.isToDependentPK()) continue;
            if (this.getAdapter().supportsUniqueConstraints() && (reverse = rel.getReverseRelationship()) != null && !reverse.isToMany() && !reverse.isToPK() && (unique = this.getAdapter().createUniqueConstraint((DbEntity)rel.getSourceEntity(), rel.getSourceAttributes())) != null) {
                list.add(unique);
            }
            if ((fk = this.getAdapter().createFkConstraint(rel)) == null) continue;
            list.add(fk);
        }
        return list;
    }

    public ValidationResult getFailures() {
        return this.failures;
    }

    public boolean shouldCreatePKSupport() {
        return this.shouldCreatePKSupport;
    }

    public boolean shouldCreateTables() {
        return this.shouldCreateTables;
    }

    public boolean shouldDropPKSupport() {
        return this.shouldDropPKSupport;
    }

    public boolean shouldDropTables() {
        return this.shouldDropTables;
    }

    public boolean shouldCreateFKConstraints() {
        return this.shouldCreateFKConstraints;
    }

    public void setShouldCreatePKSupport(boolean shouldCreatePKSupport) {
        this.shouldCreatePKSupport = shouldCreatePKSupport;
    }

    public void setShouldCreateTables(boolean shouldCreateTables) {
        this.shouldCreateTables = shouldCreateTables;
    }

    public void setShouldDropPKSupport(boolean shouldDropPKSupport) {
        this.shouldDropPKSupport = shouldDropPKSupport;
    }

    public void setShouldDropTables(boolean shouldDropTables) {
        this.shouldDropTables = shouldDropTables;
    }

    public void setShouldCreateFKConstraints(boolean shouldCreateFKConstraints) {
        this.shouldCreateFKConstraints = shouldCreateFKConstraints;
    }

    public DataDomain getDomain() {
        return this.domain;
    }

    private void prepareDbEntities(Collection<DbEntity> excludedEntities) {
        if (excludedEntities == null) {
            excludedEntities = Collections.emptyList();
        }
        ArrayList<DbEntity> tables = new ArrayList<DbEntity>();
        ArrayList<DbEntity> tablesWithAutoPk = new ArrayList<DbEntity>();
        for (DbEntity nextEntity : this.map.getDbEntities()) {
            if (nextEntity.getAttributes().size() == 0) {
                LOGGER.info("Skipping entity with no attributes: " + nextEntity.getName());
                continue;
            }
            if (excludedEntities.contains(nextEntity)) continue;
            boolean invalidAttributes = false;
            for (DbAttribute attr : nextEntity.getAttributes()) {
                if (attr.getType() != Integer.MAX_VALUE) continue;
                LOGGER.info("Skipping entity, attribute type is undefined: " + nextEntity.getName() + "." + attr.getName());
                invalidAttributes = true;
                break;
            }
            if (invalidAttributes) continue;
            tables.add(nextEntity);
            Iterator relationships = nextEntity.getRelationships().iterator();
            ArrayList<DbAttribute> pkAttributes = new ArrayList<DbAttribute>(nextEntity.getPrimaryKeys());
            while (pkAttributes.size() > 0 && relationships.hasNext()) {
                DbRelationship nextRelationship = (DbRelationship)relationships.next();
                if (!nextRelationship.isToMasterPK()) continue;
                for (DbJoin join : nextRelationship.getJoins()) {
                    pkAttributes.remove(join.getSource());
                }
            }
            if (pkAttributes.size() <= 0) continue;
            tablesWithAutoPk.add(nextEntity);
        }
        if (tables.size() > 1) {
            AshwoodEntitySorter sorter = new AshwoodEntitySorter();
            sorter.setEntityResolver(new EntityResolver(Collections.singleton(this.map)));
            sorter.sortDbEntities(tables, false);
        }
        this.dbEntitiesInInsertOrder = tables;
        this.dbEntitiesRequiringAutoPK = tablesWithAutoPk;
    }
}

