/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import java.util.Objects;
import org.apache.cayenne.access.sqlbuilder.NodeTreeVisitor;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;

public class AliasedNode
extends Node {
    protected final String alias;

    public AliasedNode(String alias) {
        this.alias = alias;
    }

    @Override
    public Node copy() {
        return new AliasedNode(this.alias);
    }

    @Override
    public QuotingAppendable append(QuotingAppendable buffer) {
        if (this.skipContent()) {
            buffer.append(' ').append(this.alias);
        }
        return buffer;
    }

    @Override
    public void visit(NodeTreeVisitor visitor) {
        if (this.skipContent()) {
            visitor.onNodeStart(this);
            visitor.onNodeEnd(this);
            return;
        }
        super.visit(visitor);
    }

    @Override
    public void appendChildrenEnd(QuotingAppendable buffer) {
        if (this.skipContent()) {
            return;
        }
        buffer.append(" ").append(this.alias);
    }

    public String getAlias() {
        return this.alias;
    }

    private boolean skipContent() {
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != NodeType.RESULT) continue;
            return false;
        }
        for (Node child : this.children) {
            if (child == null || child.getType() != NodeType.SELECT) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AliasedNode that = (AliasedNode)o;
        return Objects.equals(this.alias, that.alias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.alias);
    }
}

