/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.apache.cayenne.crypto.CayenneCryptoException;
import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;
import org.apache.cayenne.crypto.transformer.bytes.Header;

class GzipEncryptor
implements BytesEncryptor {
    static final int GZIP_THRESHOLD = 150;
    private BytesEncryptor delegate;

    public GzipEncryptor(BytesEncryptor delegate) {
        this.delegate = delegate;
    }

    @Override
    public byte[] encrypt(byte[] input, int outputOffset, byte[] flags) {
        boolean compressed;
        boolean bl = compressed = input.length >= 150;
        if (compressed) {
            try {
                input = GzipEncryptor.gzip(input);
            }
            catch (IOException e) {
                throw new CayenneCryptoException("Error compressing input", e, new Object[0]);
            }
        }
        flags[0] = Header.setCompressed(flags[0], compressed);
        return this.delegate.encrypt(input, outputOffset, flags);
    }

    static byte[] gzip(byte[] input) throws IOException {
        ByteArrayOutputStream zipBytes = new ByteArrayOutputStream(input.length);
        try (GZIPOutputStream out = new GZIPOutputStream(zipBytes);){
            out.write(input, 0, input.length);
        }
        return zipBytes.toByteArray();
    }
}

