/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.event.DispatchQueue;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.util.Invocation;

public class DefaultEventManager
implements EventManager {
    private static final int DEFAULT_DISPATCH_THREAD_COUNT = 5;
    protected final Map<EventSubject, DispatchQueue> subjects = Collections.synchronizedMap(new WeakHashMap());
    protected final List<Dispatch> eventQueue = Collections.synchronizedList(new LinkedList());
    protected final boolean singleThread;
    protected final List<DispatchThread> dispatchThreads;
    protected volatile boolean stopped;

    public DefaultEventManager() {
        this(5);
    }

    public DefaultEventManager(int dispatchThreadCount) {
        boolean bl = this.singleThread = dispatchThreadCount <= 0;
        if (!this.singleThread) {
            this.dispatchThreads = new ArrayList<DispatchThread>(dispatchThreadCount);
            String prefix = "cayenne-event-";
            for (int i = 0; i < dispatchThreadCount; ++i) {
                DispatchThread thread = new DispatchThread(prefix + i);
                this.dispatchThreads.add(thread);
                thread.start();
            }
        } else {
            this.dispatchThreads = Collections.emptyList();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isSingleThreaded() {
        return this.singleThread;
    }

    @BeforeScopeEnd
    public void shutdown() {
        if (!this.stopped) {
            this.stopped = true;
            for (DispatchThread thread : this.dispatchThreads) {
                thread.interrupt();
            }
            this.dispatchThreads.clear();
        }
    }

    @Override
    public void addListener(Object listener, String methodName, Class<?> eventParameterClass, EventSubject subject) {
        this.addListener(listener, methodName, eventParameterClass, subject, null, true);
    }

    @Override
    public void addNonBlockingListener(Object listener, String methodName, Class<?> eventParameterClass, EventSubject subject) {
        if (this.singleThread) {
            throw new IllegalStateException("DefaultEventManager is configured to be single-threaded.");
        }
        this.addListener(listener, methodName, eventParameterClass, subject, null, false);
    }

    @Override
    public void addListener(Object listener, String methodName, Class<?> eventParameterClass, EventSubject subject, Object sender) {
        this.addListener(listener, methodName, eventParameterClass, subject, sender, true);
    }

    @Override
    public void addNonBlockingListener(Object listener, String methodName, Class<?> eventParameterClass, EventSubject subject, Object sender) {
        if (this.singleThread) {
            throw new IllegalStateException("DefaultEventManager is configured to be single-threaded.");
        }
        this.addListener(listener, methodName, eventParameterClass, subject, sender, false);
    }

    protected void addListener(Object listener, String methodName, Class<?> eventParameterClass, EventSubject subject, Object sender, boolean blocking) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null.");
        }
        if (eventParameterClass == null) {
            throw new IllegalArgumentException("Event class must not be null.");
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null.");
        }
        try {
            Invocation invocation = blocking ? new Invocation(listener, methodName, eventParameterClass) : new NonBlockingInvocation(listener, methodName, eventParameterClass);
            this.dispatchQueueForSubject(subject, true).addInvocation(invocation, sender);
        }
        catch (NoSuchMethodException nsm) {
            throw new CayenneRuntimeException("Error adding listener, method name: %s", (Throwable)nsm, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(Object listener) {
        if (listener == null) {
            return false;
        }
        boolean didRemove = false;
        Map<EventSubject, DispatchQueue> map = this.subjects;
        synchronized (map) {
            if (!this.subjects.isEmpty()) {
                for (EventSubject subject : this.subjects.keySet()) {
                    didRemove |= this.removeListener(listener, subject);
                }
            }
        }
        return didRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllListeners(EventSubject subject) {
        if (subject != null) {
            Map<EventSubject, DispatchQueue> map = this.subjects;
            synchronized (map) {
                return this.subjects.remove(subject) != null;
            }
        }
        return false;
    }

    @Override
    public boolean removeListener(Object listener, EventSubject subject) {
        return this.removeListener(listener, subject, null);
    }

    @Override
    public boolean removeListener(Object listener, EventSubject subject, Object sender) {
        if (listener == null || subject == null) {
            return false;
        }
        DispatchQueue subjectQueue = this.dispatchQueueForSubject(subject, false);
        if (subjectQueue == null) {
            return false;
        }
        return subjectQueue.removeInvocations(listener, sender);
    }

    @Override
    public void postEvent(EventObject event, EventSubject subject) {
        this.dispatchEvent(new Dispatch(event, subject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postNonBlockingEvent(EventObject event, EventSubject subject) {
        if (this.singleThread) {
            throw new IllegalStateException("EventManager is configured to be single-threaded.");
        }
        List<Dispatch> list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(new Dispatch(event, subject));
            this.eventQueue.notifyAll();
        }
    }

    private void dispatchEvent(Dispatch dispatch) {
        DispatchQueue dispatchQueue = this.dispatchQueueForSubject(dispatch.subject, false);
        if (dispatchQueue != null) {
            dispatchQueue.dispatchEvent(dispatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DispatchQueue dispatchQueueForSubject(EventSubject subject, boolean create) {
        Map<EventSubject, DispatchQueue> map = this.subjects;
        synchronized (map) {
            DispatchQueue listenersStore = this.subjects.get(subject);
            if (create && listenersStore == null) {
                listenersStore = new DispatchQueue();
                this.subjects.put(subject, listenersStore);
            }
            return listenersStore;
        }
    }

    final class DispatchThread
    extends Thread {
        DispatchThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!DefaultEventManager.this.stopped) {
                Dispatch dispatch = null;
                List<Dispatch> list = DefaultEventManager.this.eventQueue;
                synchronized (list) {
                    if (DefaultEventManager.this.eventQueue.size() > 0) {
                        dispatch = DefaultEventManager.this.eventQueue.remove(0);
                    } else {
                        try {
                            DefaultEventManager.this.eventQueue.wait(180000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (DefaultEventManager.this.stopped || dispatch == null) continue;
                try {
                    dispatch.fire();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    final class NonBlockingInvocation
    extends Invocation {
        NonBlockingInvocation(Object target, String methodName, Class<?> parameterType) throws NoSuchMethodException {
            super(target, methodName, parameterType);
        }
    }

    class Dispatch {
        EventObject[] eventArgument;
        EventSubject subject;

        Dispatch(EventObject event, EventSubject subject) {
            this(new EventObject[]{event}, subject);
        }

        Dispatch(EventObject[] eventArgument, EventSubject subject) {
            this.eventArgument = eventArgument;
            this.subject = subject;
        }

        Object getSender() {
            return this.eventArgument[0].getSource();
        }

        void fire() {
            DefaultEventManager.this.dispatchEvent(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean fire(Invocation invocation) {
            if (invocation instanceof NonBlockingInvocation) {
                if (invocation.getTarget() == null) {
                    return false;
                }
                List<Dispatch> list = DefaultEventManager.this.eventQueue;
                synchronized (list) {
                    DefaultEventManager.this.eventQueue.add(new InvocationDispatch(this.eventArgument, this.subject, invocation));
                    DefaultEventManager.this.eventQueue.notifyAll();
                }
                return true;
            }
            return invocation.fire(this.eventArgument);
        }
    }

    class InvocationDispatch
    extends Dispatch {
        Invocation target;

        InvocationDispatch(EventObject[] eventArgument, EventSubject subject, Invocation target) {
            super(eventArgument, subject);
            this.target = target;
        }

        @Override
        void fire() {
            this.target.fire(this.eventArgument);
        }
    }
}

