/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.ParentAttachmentStrategy;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.ToStringBuilder;

class PrefetchProcessorNode
extends PrefetchTreeNode {
    List<DataRow> dataRows;
    List<Persistent> objects;
    ArcProperty incoming;
    ObjectResolver resolver;
    Map<Persistent, List<Persistent>> partitionByParent;
    boolean jointChildren;
    private Persistent lastResolved;
    private ParentAttachmentStrategy parentAttachmentStrategy;

    PrefetchProcessorNode(PrefetchProcessorNode parent, String segmentPath) {
        super(parent, segmentPath);
    }

    void afterInit() {
        if (this.isPartitionedByParent()) {
            this.partitionByParent = new HashMap<Persistent, List<Persistent>>();
        }
    }

    void linkToParent(Persistent object, Persistent parent) {
        if (parent != null && parent.getPersistenceState() != 5) {
            if (this.incoming instanceof ToOneProperty) {
                if (this.relationshipNotModified(parent, this.incoming)) {
                    this.incoming.writePropertyDirectly(parent, null, object);
                }
            } else {
                List peers = this.partitionByParent.computeIfAbsent(parent, p -> new ArrayList());
                if (peers.contains(object)) {
                    return;
                }
                peers.add(object);
            }
        }
    }

    boolean relationshipNotModified(Persistent object, ArcProperty property) {
        if (object.getPersistenceState() != 4) {
            return true;
        }
        ObjectDiff diff = ((DataContext)object.getObjectContext()).getObjectStore().getChangesByObjectId().get(object.getObjectId());
        if (diff == null) {
            return true;
        }
        if (diff.containsArcSnapshot(property.getName())) {
            return false;
        }
        PropertyDiffTester tester = new PropertyDiffTester(property);
        diff.apply(tester);
        return !tester.hasArcDiff();
    }

    void connectToParents() {
        if (this.isPartitionedByParent()) {
            boolean parentObjectsExist;
            PrefetchProcessorNode parent = (PrefetchProcessorNode)this.getParent();
            boolean bl = parentObjectsExist = parent.getObjects() != null && parent.getObjects().size() > 0;
            if (this.incoming.getRelationship().isToMany()) {
                if (parentObjectsExist) {
                    this.connectToNodeParents(parent.getObjects());
                } else {
                    this.connectToFaultedParents();
                }
            } else if (parentObjectsExist) {
                this.clearNullRelationships(parent.getObjects());
            }
        }
    }

    private void clearNullRelationships(List<Persistent> parentObjects) {
        for (Persistent object : parentObjects) {
            if (!(this.incoming.readPropertyDirectly(object) instanceof Fault)) continue;
            this.incoming.writePropertyDirectly(object, null, null);
        }
    }

    private void connectToNodeParents(List<Persistent> parentObjects) {
        for (Persistent parentObject : parentObjects) {
            this.connect(parentObject, this.partitionByParent.get(parentObject));
        }
    }

    private void connectToFaultedParents() {
        for (Map.Entry<Persistent, List<Persistent>> entry : this.partitionByParent.entrySet()) {
            this.connect(entry.getKey(), entry.getValue());
        }
    }

    private void connect(Persistent object, List<Persistent> related) {
        if (this.incoming.getRelationship().isToMany()) {
            if (this.relationshipNotModified(object, this.incoming)) {
                ValueHolder toManyList = (ValueHolder)this.incoming.readProperty(object);
                toManyList.setValueDirectly(related != null ? related : new ArrayList(1));
            }
        } else {
            throw new CayenneRuntimeException("To-one relationship wasn't handled properly: %s", this.incoming.getName());
        }
    }

    List<DataRow> getDataRows() {
        return this.dataRows;
    }

    List<Persistent> getObjects() {
        return this.objects;
    }

    void setResolver(ObjectResolver resolver) {
        this.resolver = resolver;
    }

    ObjectResolver getResolver() {
        return this.resolver;
    }

    ArcProperty getIncoming() {
        return this.incoming;
    }

    void setIncoming(ArcProperty incoming) {
        this.incoming = incoming;
    }

    void setDataRows(List<DataRow> dataRows) {
        this.dataRows = dataRows;
    }

    void setObjects(List<Persistent> objects) {
        this.objects = objects;
    }

    boolean isJointChildren() {
        return this.jointChildren;
    }

    void setJointChildren(boolean jointChildren) {
        this.jointChildren = jointChildren;
    }

    boolean isPartitionedByParent() {
        return this.parent != null;
    }

    Persistent getLastResolved() {
        return this.lastResolved;
    }

    void setLastResolved(Persistent lastResolved) {
        this.lastResolved = lastResolved;
    }

    public String toString() {
        String label = this.incoming != null ? this.incoming.getName() : "<root>";
        return new ToStringBuilder(this).append("incoming", label).append("phantom", this.phantom).toString();
    }

    ParentAttachmentStrategy getParentAttachmentStrategy() {
        return this.parentAttachmentStrategy;
    }

    void setParentAttachmentStrategy(ParentAttachmentStrategy parentAttachmentStrategy) {
        this.parentAttachmentStrategy = parentAttachmentStrategy;
    }

    private static class PropertyDiffTester
    implements GraphChangeHandler {
        private final ArcProperty property;
        private boolean hasArcDiff;

        public PropertyDiffTester(ArcProperty property) {
            this.property = property;
        }

        boolean hasArcDiff() {
            return this.hasArcDiff;
        }

        @Override
        public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
            if (arcId.getForwardArc().equals(this.property.getName())) {
                this.hasArcDiff = true;
            }
        }

        @Override
        public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
            if (arcId.getForwardArc().equals(this.property.getName())) {
                this.hasArcDiff = true;
            }
        }

        @Override
        public void nodeIdChanged(Object nodeId, Object newId) {
        }

        @Override
        public void nodeCreated(Object nodeId) {
        }

        @Override
        public void nodeRemoved(Object nodeId) {
        }

        @Override
        public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        }
    }
}

