/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import org.apache.cayenne.dbsync.reverse.dbload.DefaultDbLoaderDelegate;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.slf4j.Logger;

public class LoggingDbLoaderDelegate
extends DefaultDbLoaderDelegate {
    private final Logger logger;

    public LoggingDbLoaderDelegate(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void dbEntityAdded(DbEntity entity) {
        this.logger.info("  Table: " + entity.getFullyQualifiedName());
    }

    @Override
    public void dbEntityRemoved(DbEntity entity) {
        this.logger.info("  Table removed: " + entity.getFullyQualifiedName());
    }

    @Override
    public boolean dbRelationship(DbEntity entity) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("    Relationships for " + entity.getFullyQualifiedName());
        }
        return true;
    }

    @Override
    public boolean dbRelationshipLoaded(DbEntity entity, DbRelationship relationship) {
        this.logger.info("    " + String.valueOf(relationship));
        return true;
    }
}

