/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class OverwriteDialog {
    private static final String SELECT_ANOTHER = "Select Another";
    private static final String OVERWRITE = "Overwrite";
    private static final String CANCEL = "Cancel";
    private static final String[] OPTIONS = new String[]{"Select Another", "Overwrite", "Cancel"};
    protected File file;
    protected Component parent;
    protected String result = "Cancel";

    public OverwriteDialog(File file, Component parent) {
        this.file = file;
        this.parent = parent;
    }

    public void show() {
        JOptionPane pane = new JOptionPane("Do you want to overwrite an existing file: " + String.valueOf(this.file), 3);
        pane.setOptions(OPTIONS);
        JDialog dialog = pane.createDialog(this.parent, "File exists");
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        this.result = selectedValue != null ? selectedValue.toString() : CANCEL;
    }

    public boolean shouldSelectAnother() {
        return SELECT_ANOTHER.equals(this.result);
    }

    public boolean shouldOverwrite() {
        return OVERWRITE.equals(this.result);
    }

    public boolean shouldCancel() {
        return this.result == null || CANCEL.equals(this.result);
    }
}

