/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import java.util.prefs.BackingStoreException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.DisplayEvent;
import org.apache.cayenne.modeler.pref.ProjectStatePreferences;
import org.apache.cayenne.modeler.util.state.DisplayEventTypes;
import org.apache.cayenne.modeler.util.state.MultipleObjectsDisplayEventType;

public final class ProjectStateUtil {
    public void saveLastState(ProjectController controller) {
        DisplayEvent displayEvent = controller.getLastDisplayEvent();
        ConfigurationNode[] multiplyObjects = controller.getCurrentPaths();
        if (displayEvent == null && multiplyObjects == null) {
            return;
        }
        ProjectStatePreferences preferences = controller.getProjectStatePreferences();
        if (preferences.getCurrentPreference() == null) {
            return;
        }
        try {
            preferences.getCurrentPreference().clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        if (displayEvent != null) {
            DisplayEventTypes.valueOf(displayEvent.getClass().getSimpleName()).createDisplayEventType(controller).saveLastDisplayEvent();
        } else if (multiplyObjects.length != 0) {
            new MultipleObjectsDisplayEventType(controller).saveLastDisplayEvent();
        }
    }

    public void fireLastState(ProjectController controller) {
        ProjectStatePreferences preferences = controller.getProjectStatePreferences();
        String displayEventName = preferences.getEvent();
        if (!displayEventName.isEmpty()) {
            DisplayEventTypes.valueOf(displayEventName).createDisplayEventType(controller).fireLastDisplayEvent();
        }
    }
}

