/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.Fault;
import org.apache.cayenne.access.ToManyListFault;
import org.apache.cayenne.access.ToManyMapFault;
import org.apache.cayenne.access.ToManySetFault;
import org.apache.cayenne.access.ToOneFault;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.FaultFactory;

public class SingletonFaultFactory
implements FaultFactory {
    protected Fault toOneFault = new ToOneFault();
    protected Fault listFault = new ToManyListFault();
    protected Fault setFault = new ToManySetFault();
    protected Map<Accessor, Fault> mapFaults = new HashMap<Accessor, Fault>();

    @Override
    public Fault getCollectionFault() {
        return this.listFault;
    }

    @Override
    public Fault getListFault() {
        return this.listFault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fault getMapFault(Accessor mapKeyAccessor) {
        Map<Accessor, Fault> map = this.mapFaults;
        synchronized (map) {
            Fault fault = this.mapFaults.get(mapKeyAccessor);
            if (fault == null) {
                fault = new ToManyMapFault(mapKeyAccessor);
                this.mapFaults.put(mapKeyAccessor, fault);
            }
            return fault;
        }
    }

    @Override
    public Fault getSetFault() {
        return this.setFault;
    }

    @Override
    public Fault getToOneFault() {
        return this.toOneFault;
    }
}

