/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class DataContextDeleteAction {
    DataContext dataContext;

    DataContextDeleteAction(DataContext context) {
        this.dataContext = context;
    }

    boolean performDelete(Persistent object) throws DeleteDenyException {
        int oldState = object.getPersistenceState();
        if (oldState == 6 || oldState == 1) {
            return false;
        }
        if (object.getObjectContext() == null) {
            throw new CayenneRuntimeException("Attempt to delete unregistered non-TRANSIENT object: " + object);
        }
        if (object.getObjectContext() != this.dataContext) {
            throw new CayenneRuntimeException("Attempt to delete object registered in a different DataContext. Object: " + object + ", data context: " + this.dataContext);
        }
        this.dataContext.prepareForAccess(object, null, false);
        if (oldState == 2) {
            this.deleteNew(object, oldState);
        } else {
            this.deletePersistent(object, oldState);
        }
        return true;
    }

    private void deletePersistent(Persistent object, int oldState) throws DeleteDenyException {
        this.dataContext.getEntityResolver().getCallbackRegistry().performCallbacks(LifecycleEvent.PRE_REMOVE, object);
        object.setPersistenceState(6);
        this.dataContext.getObjectStore().nodeRemoved(object.getObjectId());
        this.processDeleteRules(object, oldState);
    }

    private void deleteNew(Persistent object, int oldState) throws DeleteDenyException {
        object.setPersistenceState(1);
        this.processDeleteRules(object, oldState);
        this.dataContext.getObjectStore().objectsUnregistered(Collections.singletonList(object));
        object.setObjectContext(null);
    }

    private Collection toCollection(Object object) {
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        if (object instanceof Collection) {
            return new ArrayList((Collection)object);
        }
        if (object instanceof Map) {
            return new ArrayList(((Map)object).values());
        }
        return Collections.singleton(object);
    }

    private void processDeleteRules(final Persistent object, int oldState) throws DeleteDenyException {
        ClassDescriptor descriptor = this.dataContext.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
        block5: for (ObjRelationship relationship : descriptor.getEntity().getRelationships()) {
            ArcProperty property;
            Collection relatedObjects;
            boolean processFlattened;
            boolean bl = processFlattened = relationship.isFlattened() && relationship.isToDependentEntity() && !relationship.isReadOnly();
            if (relationship.getDeleteRule() == 0 && !processFlattened || (relatedObjects = this.toCollection((property = (ArcProperty)descriptor.getProperty(relationship.getName())).readProperty(object))).size() == 0) continue;
            if (relationship.getDeleteRule() == 3) {
                object.setPersistenceState(oldState);
                String message = relatedObjects.size() == 1 ? "1 related object" : relatedObjects.size() + " related objects";
                throw new DeleteDenyException(object, relationship.getName(), message);
            }
            if (processFlattened) {
                ObjectStore objectStore = this.dataContext.getObjectStore();
                for (Persistent relatedObject : relatedObjects) {
                    objectStore.arcDeleted(object.getObjectId(), relatedObject.getObjectId(), relationship.getName());
                }
            }
            switch (relationship.getDeleteRule()) {
                case 0: {
                    break;
                }
                case 1: {
                    ArcProperty reverseArc = property.getComplimentaryReverseArc();
                    if (reverseArc == null) break;
                    final Collection finalRelatedObjects = relatedObjects;
                    reverseArc.visit(new PropertyVisitor(){

                        public boolean visitAttribute(AttributeProperty property) {
                            return false;
                        }

                        public boolean visitToMany(ToManyProperty property) {
                            for (Object relatedObject : finalRelatedObjects) {
                                property.removeTarget(relatedObject, object, true);
                            }
                            return false;
                        }

                        public boolean visitToOne(ToOneProperty property) {
                            for (Object relatedObject : finalRelatedObjects) {
                                property.setTarget(relatedObject, null, true);
                            }
                            return false;
                        }
                    });
                    break;
                }
                case 2: {
                    for (Persistent relatedObject : relatedObjects) {
                        new DataContextDeleteAction(this.dataContext).performDelete(relatedObject);
                    }
                    continue block5;
                }
                default: {
                    object.setPersistenceState(oldState);
                    throw new CayenneRuntimeException("Invalid delete rule " + relationship.getDeleteRule());
                }
            }
        }
    }
}

