/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.datanode.AdapterView;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.ModelerDbAdapter;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;

public class AdapterEditor
extends CayenneController {
    protected AdapterView view = new AdapterView();
    protected DataNode node;
    protected ObjectBinding adapterNameBinding;

    public AdapterEditor(CayenneController parent) {
        super(parent);
        this.initController();
    }

    protected void initController() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.adapterNameBinding = builder.bindToTextField(this.view.getCustomAdapter(), "adapterName");
        ((ProjectController)this.getParent()).addDataNodeDisplayListener(new DataNodeDisplayListener(){

            public void currentDataNodeChanged(DataNodeDisplayEvent e) {
                AdapterEditor.this.refreshView(e.getDataNode());
            }
        });
        this.getView().addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                AdapterEditor.this.refreshView(AdapterEditor.this.node != null ? AdapterEditor.this.node : ((ProjectController)AdapterEditor.this.getParent()).getCurrentDataNode());
            }
        });
    }

    protected void refreshView(DataNode node) {
        this.node = node;
        if (node == null) {
            this.getView().setVisible(false);
            return;
        }
        this.adapterNameBinding.updateView();
    }

    public Component getView() {
        return this.view;
    }

    public String getAdapterName() {
        if (this.node == null) {
            return null;
        }
        DbAdapter adapter = this.node.getAdapter();
        if (adapter == null) {
            return null;
        }
        if (adapter instanceof ModelerDbAdapter) {
            return ((ModelerDbAdapter)adapter).getAdapterClassName();
        }
        if (adapter.getClass() == AutoAdapter.class) {
            return null;
        }
        return adapter.getClass().getName();
    }

    public void setAdapterName(String name) {
        if (this.node == null) {
            return;
        }
        ModelerDbAdapter adapter = new ModelerDbAdapter(name, this.node.getDataSource());
        adapter.validate();
        this.node.setAdapter(adapter);
        DataNodeEvent e = new DataNodeEvent((Object)this, this.node);
        ((ProjectController)this.getParent()).fireDataNodeEvent(e);
    }
}

