/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.util.convertor;

import org.scopemvc.util.convertor.NullStringConvertor;

public class BooleanStringConvertor
extends NullStringConvertor {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();

    public Object stringAsValue(String string) throws IllegalArgumentException {
        if (this.isNull(string)) {
            return null;
        }
        if (!string.equals(TRUE) && !string.equals(FALSE)) {
            throw new IllegalArgumentException("Illegal value '" + string + "' not '" + TRUE + "' or '" + FALSE + "'");
        }
        return Boolean.valueOf(string);
    }

    public String valueAsString(Object object) throws IllegalArgumentException {
        if (object == null) {
            return this.getNullAsString();
        }
        if (!(object instanceof Boolean)) {
            throw new IllegalArgumentException("BooleanStringConvertor only operates on Boolean, not on: " + object);
        }
        return object.toString();
    }
}

