/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.model.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CompoundSelectorIterator
implements Iterator {
    private Iterator[] iterators = new Iterator[2];
    private int currentIndex = -1;

    public CompoundSelectorIterator(Iterator iterator, Iterator iterator2) {
        if (iterator == null || iterator2 == null) {
            throw new IllegalArgumentException("Create CompoundSelectorIterator with two non-null iterators.");
        }
        this.iterators[0] = iterator;
        this.iterators[1] = iterator2;
        this.currentIndex = 0;
    }

    public boolean hasNext() {
        if (this.iterators[this.currentIndex].hasNext()) {
            return true;
        }
        return this.currentIndex < this.iterators.length - 1 && this.iterators[this.currentIndex + 1].hasNext();
    }

    public Object next() {
        if (this.currentIndex <= -1 || this.currentIndex >= this.iterators.length) {
            throw new NoSuchElementException("Iterator past end of Selector list.");
        }
        if (this.iterators[this.currentIndex].hasNext()) {
            return this.iterators[this.currentIndex].next();
        }
        ++this.currentIndex;
        if (this.currentIndex >= this.iterators.length) {
            throw new NoSuchElementException("Iterator past end of Selector list.");
        }
        return this.iterators[this.currentIndex].next();
    }

    public void remove() {
        throw new UnsupportedOperationException("Can't remove Selectors from a model.");
    }
}

