/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.converters.AbstractConverter;

public final class EnumConverter<E extends Enum<E>>
extends AbstractConverter<Enum<E>> {
    public EnumConverter() {
    }

    public EnumConverter(Enum<E> defaultValue) {
        super(defaultValue);
    }

    @Override
    protected <R> R convertToType(Class<R> type, Object value) throws Throwable {
        if (Enum.class.isAssignableFrom(type)) {
            String enumValue = String.valueOf(value);
            R[] constants = type.getEnumConstants();
            if (constants == null) {
                throw this.conversionException(type, value);
            }
            for (R candidate : constants) {
                if (!((Enum)candidate).name().equalsIgnoreCase(enumValue)) continue;
                return candidate;
            }
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected Class<Enum<E>> getDefaultType() {
        return Enum.class;
    }
}

