/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.interpol;

import java.awt.event.KeyEvent;
import org.apache.commons.configuration2.interpol.ConstantLookup;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConstantLookup {
    public static final String FIELD = "Field that can be read";
    private static final String PRIVATE_FIELD = "PRIVATE";
    private ConstantLookup lookup;

    @BeforeEach
    public void setUp() throws Exception {
        this.lookup = new ConstantLookup();
    }

    @AfterEach
    public void tearDown() {
        ConstantLookup.clear();
    }

    @Test
    public void testLookupCache() {
        this.testLookupConstant();
        this.testLookupConstant();
    }

    @Test
    public void testLookupConstant() {
        Assertions.assertEquals((Object)FIELD, (Object)this.lookup.lookup(this.variable("FIELD")));
    }

    @Test
    public void testLookupInvalidSyntax() {
        Assertions.assertNull((Object)this.lookup.lookup("InvalidVariableName"));
    }

    @Test
    public void testLookupNonExisting() {
        Assertions.assertNull((Object)this.lookup.lookup(this.variable("NO_FIELD")));
    }

    @Test
    public void testLookupNonStringFromCache() {
        String var = KeyEvent.class.getName() + ".VK_ESCAPE";
        Integer expected = 27;
        Assertions.assertEquals((Object)expected, (Object)this.lookup.lookup(var));
        Assertions.assertEquals((Object)expected, (Object)this.lookup.lookup(var));
    }

    @Test
    public void testLookupNull() {
        Assertions.assertNull((Object)this.lookup.lookup(null));
    }

    @Test
    public void testLookupPrivate() {
        Assertions.assertNull((Object)this.lookup.lookup(this.variable("PRIVATE_FIELD")));
    }

    @Test
    public void testLookupUnknownClass() {
        Assertions.assertNull((Object)this.lookup.lookup("org.apache.commons.configuration.NonExistingConfig.Field that can be read"));
    }

    private String variable(String field) {
        return this.getClass().getName() + '.' + field;
    }
}

