/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestFileSystemLocationStrategy {
    private FileSystemLocationStrategy strategy;

    @BeforeEach
    public void setUp() throws Exception {
        this.strategy = new FileSystemLocationStrategy();
    }

    @Test
    public void testLocate() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        URL url = ConfigurationAssert.getTestURL("test.xml");
        String basePath = "testBasePath";
        String fileName = "testFileName.txt";
        Mockito.when((Object)fs.locateFromURL("testBasePath", "testFileName.txt")).thenReturn((Object)url);
        FileLocator locator = FileLocatorUtils.fileLocator().basePath("testBasePath").fileName("testFileName.txt").fileSystem(FileLocatorUtils.DEFAULT_FILE_SYSTEM).sourceURL(ConfigurationAssert.getTestURL("test.properties")).create();
        Assertions.assertSame((Object)url, (Object)this.strategy.locate(fs, locator));
        ((FileSystem)Mockito.verify((Object)fs)).locateFromURL("testBasePath", "testFileName.txt");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fs});
    }
}

