/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.plist;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.plist.ParseException;
import org.apache.commons.configuration2.plist.PropertyListConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestPropertyListConfiguration {
    @TempDir
    public File tempFolder;
    private PropertyListConfiguration config;
    private final File testProperties = ConfigurationAssert.getTestFile("test.plist");

    private static List<ImmutableNode> getNamedChildren(HierarchicalConfiguration<ImmutableNode> config, String name) {
        NodeHandler handler = config.getNodeModel().getNodeHandler();
        return handler.getChildren((Object)((ImmutableNode)handler.getRootNode()), name);
    }

    private static void load(PropertyListConfiguration c, File f) throws ConfigurationException {
        new FileHandler((FileBased)c).load(f);
    }

    private void saveConfig(File file) throws ConfigurationException {
        new FileHandler((FileBased)this.config).save(file);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.config = new PropertyListConfiguration();
        TestPropertyListConfiguration.load(this.config, this.testProperties);
    }

    @Test
    public void testAddDataProperty() throws Exception {
        File saveFile = TempDirUtils.newFile(this.tempFolder);
        byte[] expected = new byte[]{1, 2, 3, 4};
        this.config = new PropertyListConfiguration();
        this.config.addProperty("foo", (Object)expected);
        this.saveConfig(saveFile);
        PropertyListConfiguration config2 = new PropertyListConfiguration();
        TestPropertyListConfiguration.load(config2, saveFile);
        Object array = config2.getProperty("foo");
        Assertions.assertNotNull((Object)array);
        Assertions.assertEquals(byte[].class, array.getClass());
        Assertions.assertArrayEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    public void testArray() {
        List list = (List)Assertions.assertInstanceOf(List.class, (Object)this.config.getProperty("array"));
        Assertions.assertEquals(Arrays.asList("value1", "value2", "value3"), (Object)list);
    }

    @Test
    public void testData() {
        byte[] bytes = (byte[])Assertions.assertInstanceOf(byte[].class, (Object)this.config.getProperty("data"));
        Assertions.assertArrayEquals((byte[])"foo bar".getBytes(), (byte[])bytes);
    }

    @Test
    public void testDate() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2002, 2, 22, 11, 30, 0);
        cal.setTimeZone(TimeZone.getTimeZone("GMT+0100"));
        Date date = cal.getTime();
        Assertions.assertEquals((Object)date, (Object)this.config.getProperty("date"));
    }

    @Test
    public void testDictionary() {
        Assertions.assertEquals((Object)"bar1", (Object)this.config.getProperty("dictionary.foo1"));
        Assertions.assertEquals((Object)"bar2", (Object)this.config.getProperty("dictionary.foo2"));
    }

    @Test
    public void testDictionaryArray() {
        String key = "dictionary-array";
        Object array = this.config.getProperty("dictionary-array");
        Assertions.assertNotNull((Object)array);
        Assertions.assertInstanceOf(List.class, (Object)array);
        List list = this.config.getList("dictionary-array");
        Assertions.assertEquals((int)2, (int)list.size());
        Configuration conf1 = (Configuration)Assertions.assertInstanceOf(Configuration.class, list.get(0));
        Assertions.assertFalse((boolean)conf1.isEmpty());
        Assertions.assertEquals((Object)"bar", (Object)conf1.getProperty("foo"));
        Configuration conf2 = (Configuration)Assertions.assertInstanceOf(Configuration.class, list.get(1));
        Assertions.assertFalse((boolean)conf2.isEmpty());
        Assertions.assertEquals((Object)"value", (Object)conf2.getProperty("key"));
    }

    @Test
    public void testEmptyArray() {
        String key = "empty-array";
        Assertions.assertNotNull((Object)this.config.getProperty("empty-array"));
        List list = (List)this.config.getProperty("empty-array");
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testFormatDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2007, 9, 29, 23, 4, 30);
        cal.setTimeZone(TimeZone.getTimeZone("GMT-0230"));
        Assertions.assertEquals((Object)"<*D2007-10-29 23:04:30 -0230>", (Object)PropertyListConfiguration.formatDate((Calendar)cal));
        cal.clear();
        cal.set(2007, 9, 30, 22, 2, 15);
        cal.setTimeZone(TimeZone.getTimeZone("GMT+1111"));
        Assertions.assertEquals((Object)"<*D2007-10-30 22:02:15 +1111>", (Object)PropertyListConfiguration.formatDate((Calendar)cal));
    }

    @Test
    public void testInitCopy() {
        PropertyListConfiguration copy = new PropertyListConfiguration((HierarchicalConfiguration)this.config);
        Assertions.assertFalse((boolean)copy.isEmpty());
    }

    @Test
    public void testLoad() {
        Assertions.assertFalse((boolean)this.config.isEmpty());
    }

    @Test
    public void testLoadWithError() {
        this.config = new PropertyListConfiguration();
        FileHandler fileHandler = new FileHandler((FileBased)this.config);
        StringReader reader = new StringReader("");
        ConfigurationException e = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> fileHandler.load((Reader)reader));
        Assertions.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void testNestedArrays() {
        String key = "nested-arrays";
        Object array = this.config.getProperty("nested-arrays");
        Assertions.assertNotNull((Object)array);
        Assertions.assertInstanceOf(List.class, (Object)array);
        List list = this.config.getList("nested-arrays");
        Assertions.assertEquals((int)2, (int)list.size());
        List list1 = (List)Assertions.assertInstanceOf(List.class, list.get(0));
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)list1);
        List list2 = (List)Assertions.assertInstanceOf(List.class, list.get(1));
        Assertions.assertEquals(Arrays.asList("c", "d"), (Object)list2);
    }

    @Test
    public void testNestedDictionaries() {
        Assertions.assertEquals((Object)"value", (Object)this.config.getString("nested-dictionaries.foo.bar.key"));
    }

    @Test
    public void testParseDateInvalidChar() {
        Assertions.assertThrows(ParseException.class, () -> PropertyListConfiguration.parseDate((String)"<*D2002+03-22 11:30:00 +0100>"));
    }

    @Test
    public void testParseDateNoNumber() {
        Assertions.assertThrows(ParseException.class, () -> PropertyListConfiguration.parseDate((String)"<*D2002-03-22 1c:30:00 +0100>"));
    }

    @Test
    public void testParseDateNull() {
        Assertions.assertThrows(ParseException.class, () -> PropertyListConfiguration.parseDate(null));
    }

    @Test
    public void testParseDateTooShort() {
        Assertions.assertThrows(ParseException.class, () -> PropertyListConfiguration.parseDate((String)"<*D2002-03-22 11:3>"));
    }

    @Test
    public void testQuotedString() {
        Assertions.assertEquals((Object)"string2", (Object)this.config.getProperty("quoted-string"));
        Assertions.assertEquals((Object)"this is a string", (Object)this.config.getProperty("quoted-string2"));
        Assertions.assertEquals((Object)"this is a \"complex\" string {(=,;)}", (Object)this.config.getProperty("complex-string"));
    }

    @Test
    public void testQuoteString() {
        Assertions.assertNull((Object)this.config.quoteString(null));
        Assertions.assertEquals((Object)"abcd", (Object)this.config.quoteString("abcd"));
        Assertions.assertEquals((Object)"\"ab cd\"", (Object)this.config.quoteString("ab cd"));
        Assertions.assertEquals((Object)"\"foo\\\"bar\"", (Object)this.config.quoteString("foo\"bar"));
        Assertions.assertEquals((Object)"\"foo;bar\"", (Object)this.config.quoteString("foo;bar"));
    }

    @Test
    public void testSave() throws Exception {
        File savedFile = TempDirUtils.newFile("testsave.plist", this.tempFolder);
        this.saveConfig(savedFile);
        Assertions.assertTrue((boolean)savedFile.exists());
        PropertyListConfiguration checkConfig = new PropertyListConfiguration();
        TestPropertyListConfiguration.load(checkConfig, savedFile);
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assertions.assertTrue((boolean)checkConfig.containsKey(key), (String)("The saved configuration doesn't contain the key '" + key + "'"));
            Object value = checkConfig.getProperty(key);
            if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                Assertions.assertArrayEquals((byte[])((byte[])this.config.getProperty(key)), (byte[])array, (String)("Value of the '" + key + "' property"));
                continue;
            }
            if (value instanceof List) {
                List list1 = (List)this.config.getProperty(key);
                List list2 = (List)value;
                Assertions.assertEquals((int)list1.size(), (int)list2.size(), (String)("The size of the list for the key '" + key + "' doesn't match"));
                for (int i = 0; i < list2.size(); ++i) {
                    Object value1 = list1.get(i);
                    Object value2 = list2.get(i);
                    if (value1 instanceof Configuration) {
                        StrictConfigurationComparator comparator = new StrictConfigurationComparator();
                        Assertions.assertTrue((boolean)comparator.compare((Configuration)value1, (Configuration)value2), (String)("The dictionnary at index " + i + " for the key '" + key + "' doesn't match"));
                        continue;
                    }
                    Assertions.assertEquals(value1, value2, (String)("Element at index " + i + " for the key '" + key + "'"));
                }
                Assertions.assertEquals((Object)this.config.getProperty(key), (Object)list1, (String)("Value of the '" + key + "' property"));
                continue;
            }
            Assertions.assertEquals((Object)this.config.getProperty(key), (Object)checkConfig.getProperty(key), (String)("Value of the '" + key + "' property"));
        }
    }

    @Test
    public void testSaveEmptyDictionary() throws Exception {
        File savedFile = TempDirUtils.newFile("testsave.plist", this.tempFolder);
        this.saveConfig(savedFile);
        Assertions.assertTrue((boolean)savedFile.exists());
        PropertyListConfiguration checkConfig = new PropertyListConfiguration();
        TestPropertyListConfiguration.load(checkConfig, savedFile);
        Assertions.assertFalse((boolean)TestPropertyListConfiguration.getNamedChildren((HierarchicalConfiguration<ImmutableNode>)this.config, "empty-dictionary").isEmpty());
        Assertions.assertFalse((boolean)TestPropertyListConfiguration.getNamedChildren((HierarchicalConfiguration<ImmutableNode>)checkConfig, "empty-dictionary").isEmpty());
    }

    @Test
    public void testSetDataProperty() throws Exception {
        File saveFile = TempDirUtils.newFile(this.tempFolder);
        byte[] expected = new byte[]{1, 2, 3, 4};
        this.config = new PropertyListConfiguration();
        this.config.setProperty("foo", (Object)expected);
        this.saveConfig(saveFile);
        PropertyListConfiguration config2 = new PropertyListConfiguration();
        TestPropertyListConfiguration.load(config2, saveFile);
        Object array = config2.getProperty("foo");
        Assertions.assertNotNull((Object)array);
        Assertions.assertEquals(byte[].class, array.getClass());
        Assertions.assertArrayEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    public void testString() {
        Assertions.assertEquals((Object)"string1", (Object)this.config.getProperty("simple-string"));
    }
}

