/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.HashMap;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderEventListenerImpl;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.ReloadingDetectorFactory;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.FileHandlerReloadingDetector;
import org.apache.commons.configuration2.reloading.ReloadingDetector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestReloadingFileBasedConfigurationBuilder {
    @Test
    public void testCreateReloadingDetectorDefaultFactory() throws ConfigurationException {
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class);
        FileHandler handler = new FileHandler();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        long refreshDelay = 60000L;
        params.setReloadingRefreshDelay(Long.valueOf(60000L));
        FileHandlerReloadingDetector detector = (FileHandlerReloadingDetector)builder.createReloadingDetector(handler, params);
        Assertions.assertSame((Object)handler, (Object)detector.getFileHandler());
        Assertions.assertEquals((long)60000L, (long)detector.getRefreshDelay());
    }

    @Test
    public void testCreateReloadingDetectoryCustomFactory() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)Mockito.mock(ReloadingDetector.class);
        ReloadingDetectorFactory factory = (ReloadingDetectorFactory)Mockito.mock(ReloadingDetectorFactory.class);
        FileHandler handler = new FileHandler();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Mockito.when((Object)factory.createReloadingDetector(handler, params)).thenReturn((Object)detector);
        params.setReloadingDetectorFactory(factory);
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class);
        Assertions.assertSame((Object)detector, (Object)builder.createReloadingDetector(handler, params));
        ((ReloadingDetectorFactory)Mockito.verify((Object)factory)).createReloadingDetector(handler, params);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{factory});
    }

    @Test
    public void testGetConfigurationNoLocation() throws ConfigurationException {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("throwExceptionOnMissing", Boolean.TRUE);
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class, params);
        PropertiesConfiguration conf = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)conf.isThrowExceptionOnMissing());
        Assertions.assertTrue((boolean)conf.isEmpty());
    }

    @Test
    public void testInitAllowFailOnInitFlag() {
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class, null, true);
        Assertions.assertTrue((boolean)builder.isAllowFailOnInit());
    }

    @Test
    public void testReloadingControllerEvents() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)Mockito.mock(ReloadingDetector.class);
        Mockito.when((Object)detector.isReloadingRequired()).thenReturn((Object)Boolean.TRUE);
        ReloadingFileBasedConfigurationBuilderTestImpl builder = new ReloadingFileBasedConfigurationBuilderTestImpl(detector);
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.RESET, listener);
        builder.getConfiguration();
        builder.getReloadingController().checkForReloading(null);
        listener.nextEvent(ConfigurationBuilderEvent.RESET);
        listener.assertNoMoreEvents();
        ((ReloadingDetector)Mockito.verify((Object)detector)).isReloadingRequired();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{detector});
    }

    @Test
    public void testReloadingDetectorIsReloadingRequired() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)Mockito.mock(ReloadingDetector.class);
        Mockito.when((Object)detector.isReloadingRequired()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        ReloadingFileBasedConfigurationBuilderTestImpl builder = new ReloadingFileBasedConfigurationBuilderTestImpl(detector);
        builder.getConfiguration();
        ReloadingDetector ctrlDetector = builder.getReloadingController().getDetector();
        Assertions.assertTrue((boolean)ctrlDetector.isReloadingRequired());
        Assertions.assertFalse((boolean)ctrlDetector.isReloadingRequired());
        Assertions.assertSame((Object)builder.getFileHandler(), (Object)builder.getHandlerForDetector());
        ((ReloadingDetector)Mockito.verify((Object)detector, (VerificationMode)Mockito.times((int)2))).isReloadingRequired();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{detector});
    }

    @Test
    public void testReloadingDetectorNoFileHandler() {
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class);
        ReloadingDetector ctrlDetector = builder.getReloadingController().getDetector();
        ctrlDetector.reloadingPerformed();
        Assertions.assertFalse((boolean)ctrlDetector.isReloadingRequired());
    }

    @Test
    public void testReloadingDetectorReloadingPerformed() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)Mockito.mock(ReloadingDetector.class);
        ReloadingFileBasedConfigurationBuilderTestImpl builder = new ReloadingFileBasedConfigurationBuilderTestImpl(detector);
        builder.getConfiguration();
        ReloadingDetector ctrlDetector = builder.getReloadingController().getDetector();
        ctrlDetector.reloadingPerformed();
        ((ReloadingDetector)Mockito.verify((Object)detector)).reloadingPerformed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{detector});
    }

    @Test
    public void testResetReloadingStateInGetConfiguration() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)Mockito.mock(ReloadingDetector.class);
        Mockito.when((Object)detector.isReloadingRequired()).thenReturn((Object)Boolean.TRUE);
        ReloadingFileBasedConfigurationBuilderTestImpl builder = new ReloadingFileBasedConfigurationBuilderTestImpl(detector);
        PropertiesConfiguration config1 = (PropertiesConfiguration)builder.getConfiguration();
        builder.getReloadingController().checkForReloading(null);
        PropertiesConfiguration config2 = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertNotSame((Object)config1, (Object)config2);
        Assertions.assertFalse((boolean)builder.getReloadingController().isInReloadingState());
        ((ReloadingDetector)Mockito.verify((Object)detector)).isReloadingRequired();
        ((ReloadingDetector)Mockito.verify((Object)detector)).reloadingPerformed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{detector});
    }

    private static final class ReloadingFileBasedConfigurationBuilderTestImpl
    extends ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> {
        private final ReloadingDetector mockDetector;
        private FileHandler handlerForDetector;

        public ReloadingFileBasedConfigurationBuilderTestImpl(ReloadingDetector detector) {
            super(PropertiesConfiguration.class);
            this.mockDetector = detector;
        }

        protected ReloadingDetector createReloadingDetector(FileHandler handler, FileBasedBuilderParametersImpl fbparams) {
            this.handlerForDetector = handler;
            return this.mockDetector;
        }

        public FileHandler getHandlerForDetector() {
            return this.handlerForDetector;
        }
    }
}

