/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfigurationEventTypes {
    private void checkErrorEvent(EventType<ConfigurationErrorEvent> type) {
        Assertions.assertSame((Object)ConfigurationErrorEvent.ANY, (Object)type.getSuperType(), (String)("Wrong super type for " + type));
    }

    private void checkHierarchicalEvent(EventType<ConfigurationEvent> eventType) {
        Assertions.assertSame((Object)ConfigurationEvent.ANY_HIERARCHICAL, (Object)eventType.getSuperType(), (String)("Wrong super type for " + eventType));
    }

    private void checkUpdateEvent(EventType<ConfigurationEvent> eventType) {
        Assertions.assertSame((Object)ConfigurationEvent.ANY, (Object)eventType.getSuperType(), (String)("Wrong super type for " + eventType));
    }

    @Test
    void testAddNodesEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ADD_NODES);
    }

    @Test
    void testAddPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ADD_PROPERTY);
    }

    @Test
    void testBaseErrorEventType() {
        Assertions.assertEquals((Object)Event.ANY, (Object)ConfigurationErrorEvent.ANY.getSuperType());
    }

    @Test
    void testClearEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR);
    }

    @Test
    void testClearPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR_PROPERTY);
    }

    @Test
    void testClearTreeEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR_TREE);
    }

    @Test
    void testConfigurationEventType() {
        Assertions.assertSame((Object)Event.ANY, (Object)ConfigurationEvent.ANY.getSuperType());
    }

    @Test
    void testFetchSuperEventTypesForBaseType() {
        Set superTypes = EventType.fetchSuperEventTypes((EventType)Event.ANY);
        Assertions.assertEquals(Collections.singleton(Event.ANY), (Object)superTypes);
    }

    @Test
    void testFetchSuperEventTypesNull() {
        Set superTypes = EventType.fetchSuperEventTypes(null);
        Assertions.assertTrue((boolean)superTypes.isEmpty());
    }

    @Test
    void testFetchSuperEventTypesOfType() {
        Set superTypes = EventType.fetchSuperEventTypes((EventType)ConfigurationEvent.ADD_NODES);
        HashSet<EventType> expected = new HashSet<EventType>();
        expected.add(ConfigurationEvent.ADD_NODES);
        expected.add(ConfigurationEvent.ANY_HIERARCHICAL);
        expected.add(ConfigurationEvent.ANY);
        expected.add(Event.ANY);
        Assertions.assertEquals(expected, (Object)superTypes);
    }

    @Test
    void testHierarchicalEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ANY_HIERARCHICAL);
    }

    @Test
    void testIsInstanceOfBaseNull() {
        Assertions.assertFalse((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ANY, null));
    }

    @Test
    void testIsInstanceOfDerivedNull() {
        Assertions.assertFalse((boolean)EventType.isInstanceOf(null, (EventType)Event.ANY));
    }

    @Test
    void testIsInstanceOfFalse() {
        Assertions.assertFalse((boolean)EventType.isInstanceOf((EventType)ConfigurationErrorEvent.READ, (EventType)ConfigurationEvent.ANY));
    }

    @Test
    void testIsInstanceOfTrue() {
        Assertions.assertTrue((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ANY_HIERARCHICAL));
        Assertions.assertTrue((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ANY));
        Assertions.assertTrue((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)Event.ANY));
        Assertions.assertTrue((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ADD_NODES));
    }

    @Test
    void testReadErrorEventType() {
        this.checkErrorEvent((EventType<ConfigurationErrorEvent>)ConfigurationErrorEvent.READ);
    }

    @Test
    void testSetPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.SET_PROPERTY);
    }

    @Test
    void testSubnodeChangedEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.SUBNODE_CHANGED);
    }

    @Test
    void testWriteErrorEventType() {
        this.checkErrorEvent((EventType<ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE);
    }
}

